/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Arrays;
import lombok.Generated;
import org.apache.kylin.cube.model.SelectRule;
import org.apache.kylin.metadata.cube.cuboid.NAggregationGroup;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;

public class AggGroupResponse
implements Serializable {
    @JsonProperty(value="includes")
    private String[] includes;
    @JsonProperty(value="select_rule")
    private AggSelectRule aggSelectRule;

    public AggGroupResponse() {
    }

    public AggGroupResponse(NDataModel dataModel, NAggregationGroup aggregationGroup) {
        this.includes = AggGroupResponse.intArray2StringArray(aggregationGroup.getIncludes(), dataModel);
        this.aggSelectRule = new AggSelectRule(dataModel, aggregationGroup.getSelectRule());
    }

    public static String[] intArray2StringArray(Integer[] ints, NDataModel dataModel) {
        String[] res;
        int len;
        int n = len = ints == null ? 0 : ints.length;
        if (len > 0) {
            res = new String[len];
            for (int i = 0; i < len; ++i) {
                res[i] = ((TblColRef)dataModel.getEffectiveDimensions().get((Object)ints[i])).getIdentity();
            }
        } else {
            res = new String[]{};
        }
        return res;
    }

    public static String[][] intArray2StringArray(Integer[][] ints, NDataModel dataModel) {
        String[][] res;
        int p1;
        int n = p1 = ints == null ? 0 : ints.length;
        if (p1 > 0) {
            res = new String[p1][];
            for (int i = 0; i < p1; ++i) {
                int p2 = ints[i].length;
                res[i] = new String[p2];
                for (int j = 0; j < p2; ++j) {
                    res[i][j] = ((TblColRef)dataModel.getEffectiveDimensions().get((Object)ints[i][j])).getIdentity();
                }
            }
        } else {
            res = new String[0][0];
        }
        return res;
    }

    @Generated
    public String[] getIncludes() {
        return this.includes;
    }

    @Generated
    public AggSelectRule getAggSelectRule() {
        return this.aggSelectRule;
    }

    @Generated
    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Generated
    public void setAggSelectRule(AggSelectRule aggSelectRule) {
        this.aggSelectRule = aggSelectRule;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggGroupResponse)) {
            return false;
        }
        AggGroupResponse other = (AggGroupResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIncludes(), other.getIncludes())) {
            return false;
        }
        AggSelectRule this$aggSelectRule = this.getAggSelectRule();
        AggSelectRule other$aggSelectRule = other.getAggSelectRule();
        return !(this$aggSelectRule == null ? other$aggSelectRule != null : !((Object)this$aggSelectRule).equals(other$aggSelectRule));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AggGroupResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getIncludes());
        AggSelectRule $aggSelectRule = this.getAggSelectRule();
        result = result * 59 + ($aggSelectRule == null ? 43 : ((Object)$aggSelectRule).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AggGroupResponse(includes=" + Arrays.deepToString(this.getIncludes()) + ", aggSelectRule=" + this.getAggSelectRule() + ")";
    }

    public static class AggSelectRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="hierarchy_dims")
        public String[][] hierarchyDims;
        @JsonProperty(value="mandatory_dims")
        public String[] mandatoryDims;
        @JsonProperty(value="joint_dims")
        public String[][] jointDims;

        public AggSelectRule() {
        }

        public AggSelectRule(NDataModel dataModel, SelectRule selectRule) {
            this.hierarchyDims = AggGroupResponse.intArray2StringArray(selectRule.getHierarchyDims(), dataModel);
            this.mandatoryDims = AggGroupResponse.intArray2StringArray(selectRule.getMandatoryDims(), dataModel);
            this.jointDims = AggGroupResponse.intArray2StringArray(selectRule.getJointDims(), dataModel);
        }

        @Generated
        public String[][] getHierarchyDims() {
            return this.hierarchyDims;
        }

        @Generated
        public String[] getMandatoryDims() {
            return this.mandatoryDims;
        }

        @Generated
        public String[][] getJointDims() {
            return this.jointDims;
        }

        @Generated
        public void setHierarchyDims(String[][] hierarchyDims) {
            this.hierarchyDims = hierarchyDims;
        }

        @Generated
        public void setMandatoryDims(String[] mandatoryDims) {
            this.mandatoryDims = mandatoryDims;
        }

        @Generated
        public void setJointDims(String[][] jointDims) {
            this.jointDims = jointDims;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AggSelectRule)) {
                return false;
            }
            AggSelectRule other = (AggSelectRule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals((Object[])this.getHierarchyDims(), (Object[])other.getHierarchyDims())) {
                return false;
            }
            if (!Arrays.deepEquals(this.getMandatoryDims(), other.getMandatoryDims())) {
                return false;
            }
            return Arrays.deepEquals((Object[])this.getJointDims(), (Object[])other.getJointDims());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AggSelectRule;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode((Object[])this.getHierarchyDims());
            result = result * 59 + Arrays.deepHashCode(this.getMandatoryDims());
            result = result * 59 + Arrays.deepHashCode((Object[])this.getJointDims());
            return result;
        }

        @Generated
        public String toString() {
            return "AggGroupResponse.AggSelectRule(hierarchyDims=" + Arrays.deepToString((Object[])this.getHierarchyDims()) + ", mandatoryDims=" + Arrays.deepToString(this.getMandatoryDims()) + ", jointDims=" + Arrays.deepToString((Object[])this.getJointDims()) + ")";
        }
    }
}

