/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.NCubeDescResponse;
import org.apache.kylin.rest.response.NCubeResponse;
import org.apache.kylin.rest.service.ModelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cube_desc"}, produces={"application/vnd.apache.kylin-v2+json"})
public class NCubeDescControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="modelService")
    private ModelService modelService;

    @ApiOperation(value="getCube", tags={"AI"})
    @GetMapping(value={"/{projectName}/{cubeName}"})
    @ResponseBody
    public EnvelopeResponse<NCubeResponse> getCube(@PathVariable(value="projectName") String project, @PathVariable(value="cubeName") String modelAlias) {
        this.checkProjectName(project);
        NCubeDescResponse cubeDesc = this.modelService.getCubeWithExactModelName(modelAlias, project);
        return new EnvelopeResponse("000", (Object)new NCubeResponse((Serializable)cubeDesc), "");
    }
}

