/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.util.Set;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.CustomFileService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/custom"}, produces={"application/vnd.apache.kylin-v4+json", "application/vnd.apache.kylin-v4-public+json"})
public class CustomFileController
extends NBasicController {
    @Autowired
    private CustomFileService customFileService;

    @PostMapping(value={"jar"})
    @ResponseBody
    public EnvelopeResponse<Set<String>> upload(@RequestParam(value="file") MultipartFile file, @RequestParam(value="project") String project, @RequestParam(value="jar_type") String jarType) {
        this.checkStreamingEnabled();
        if (file.isEmpty()) {
            return new EnvelopeResponse("999", (Object)Sets.newHashSet(), "");
        }
        this.checkRequiredArg("jar_type", jarType);
        String projectName = this.checkProjectName(project);
        Set classList = this.customFileService.uploadJar(file, projectName, jarType);
        return new EnvelopeResponse("000", (Object)classList, "");
    }

    @DeleteMapping(value={"jar"})
    @ResponseBody
    public EnvelopeResponse<String> removeJar(@RequestParam(value="project") String project, @RequestParam(value="jar_name") String jarName, @RequestParam(value="jar_type") String jarType) {
        this.checkStreamingEnabled();
        this.checkRequiredArg("jar_type", jarType);
        String projectName = this.checkProjectName(project);
        String removedJar = this.customFileService.removeJar(projectName, jarName, jarType);
        return new EnvelopeResponse("000", (Object)removedJar, "");
    }
}

