/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaSite;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.ColumnMetaData;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.ArrayImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.Cursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.KylinDateAccessor;

public class KylinDelegateCursor
extends AbstractCursor {
    private static final int FLOAT_TYPE_ID = 6;
    private final AbstractCursor cursor;

    public KylinDelegateCursor(AbstractCursor cursor) {
        this.cursor = cursor;
    }

    @Override
    protected Cursor.Accessor createAccessor(ColumnMetaData columnMetaData, AbstractCursor.Getter getter, Calendar localCalendar, ArrayImpl.Factory factory) {
        if (columnMetaData.type.id == 91 && columnMetaData.type.rep == ColumnMetaData.Rep.JAVA_SQL_DATE) {
            return new KylinDateAccessor(getter);
        }
        HashSet<Integer> NUMBER_META_TYPE_IDS = new HashSet<Integer>(Arrays.asList(-6, -5, 2, 3, 4, 5, 6, 7, 8));
        if (columnMetaData.type.rep == ColumnMetaData.Rep.NUMBER && NUMBER_META_TYPE_IDS.contains(columnMetaData.type.id)) {
            return new KylinNumberAccessor(getter, columnMetaData.scale);
        }
        if (columnMetaData.type.id == 6) {
            return new KylinFloatToDoubleAccessor(getter);
        }
        return this.cursor.createAccessor(columnMetaData, getter, localCalendar, factory);
    }

    @Override
    public boolean wasNull() {
        return this.cursor.wasNull();
    }

    @Override
    protected AbstractCursor.Getter createGetter(int ordinal) {
        return this.cursor.createGetter(ordinal);
    }

    @Override
    public boolean next() {
        return this.cursor.next();
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    private static class KylinNumberAccessor
    extends AbstractCursor.NumberAccessor {
        KylinNumberAccessor(AbstractCursor.Getter getter, int scale) {
            super(getter, scale);
        }

        @Override
        public BigDecimal getBigDecimal(int scale) throws SQLException {
            Number n = this.getNumber();
            if (n == null) {
                return null;
            }
            BigDecimal decimal = AvaticaSite.toBigDecimal(n);
            return 0 != scale ? decimal.setScale(scale, RoundingMode.DOWN) : decimal;
        }
    }

    private static class KylinFloatToDoubleAccessor
    extends AbstractCursor.AccessorImpl {
        private KylinFloatToDoubleAccessor(AbstractCursor.Getter getter) {
            super(getter);
        }

        @Override
        public double getDouble() throws SQLException {
            Object obj = this.getObject();
            if (null == obj) {
                return 0.0;
            }
            if (obj instanceof Double) {
                return (Double)obj;
            }
            if (obj instanceof BigDecimal) {
                return ((BigDecimal)obj).doubleValue();
            }
            return Double.parseDouble(obj.toString());
        }
    }
}

