/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.kylin.jdbc.KylinCheckSql;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.CommandLine;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.GnuParser;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.HelpFormatter;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.Option;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.OptionBuilder;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.Options;
import org.apache.kylin.jdbc.shaded.org.apache.commons.cli.ParseException;
import org.apache.kylin.jdbc.shaded.org.apache.commons.io.FileUtils;

public class QueryCLI {
    private static final String PROJECT_ARG_NAME = "project";
    private static final Option OPT_SERVICE;
    private static final Option OPT_PROJECT;
    private static final Option OPT_USER;
    private static final Option OPT_PWD;
    private static final Options OPTIONS;
    final PrintWriter out;
    final BufferedReader in;
    ParseException parserException;
    String inpService;
    String inpProject;
    String inpUser;
    String inpPwd;
    String[] inpSqls;

    public static void main(String[] args) {
        QueryCLI cli = new QueryCLI(args, System.in, System.out);
        int exitCode = cli.run();
        System.exit(exitCode);
    }

    public QueryCLI(String[] args, InputStream in, OutputStream out) {
        this.out = new PrintWriter(out, true);
        this.in = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        try {
            GnuParser parser = new GnuParser();
            CommandLine line = parser.parse(OPTIONS, args);
            this.inpService = line.getOptionValue("s");
            this.inpProject = line.getOptionValue(PROJECT_ARG_NAME);
            this.inpUser = line.getOptionValue("u", "ADMIN");
            this.inpPwd = line.getOptionValue("p", "KYLIN");
            this.inpSqls = line.getArgs();
        }
        catch (ParseException e) {
            this.parserException = e;
        }
    }

    public int run() {
        if (this.parserException != null) {
            this.printHelp();
            return -1;
        }
        try {
            this.initDriver();
        }
        catch (Exception e) {
            this.out.println("[ERROR] Failed to init Driver" + e.getMessage());
            e.printStackTrace(this.out);
            return -2;
        }
        boolean hasError = false;
        for (String sqlOrFile : this.inpSqls) {
            try {
                this.runSql(sqlOrFile);
            }
            catch (Exception ex) {
                this.out.println("[ERROR] Failed to run: " + sqlOrFile);
                ex.printStackTrace(this.out);
                hasError = true;
            }
            this.out.println();
        }
        return hasError ? -3 : 0;
    }

    private void initDriver() {
        try {
            Class.forName("org.apache.kylin.jdbc.Driver");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSql(String sqlOrFile) throws Exception {
        String sql = this.getSql(sqlOrFile);
        this.out.println("Running: " + sql);
        Properties props = new Properties();
        props.put("user", this.inpUser);
        props.put("password", this.inpPwd);
        int placeholderCount = KylinCheckSql.countDynamicPlaceholder(sql);
        boolean isPreparedStatement = placeholderCount > 0;
        ResultSet rs = null;
        try (Connection conn = DriverManager.getConnection("jdbc:kylin://" + this.inpService + "/" + this.inpProject, props);){
            long start;
            Throwable throwable;
            if (isPreparedStatement) {
                throwable = null;
                try (PreparedStatement prep = conn.prepareStatement(sql);){
                    start = System.currentTimeMillis();
                    rs = prep.executeQuery();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            throwable = null;
            try (Statement stat = conn.createStatement();){
                start = System.currentTimeMillis();
                rs = stat.executeQuery(sql);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            int rows = this.printResultSet(rs);
            double seconds = (double)(System.currentTimeMillis() - start) / 1000.0;
            this.out.println("----");
            this.out.println(rows + " rows, " + seconds + " seconds");
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private String getSql(String sqlOrFile) throws IOException {
        File f = new File(sqlOrFile);
        if (f.exists()) {
            return FileUtils.readFileToString(f, StandardCharsets.UTF_8);
        }
        return sqlOrFile;
    }

    private int printResultSet(ResultSet rs) throws SQLException {
        int i;
        ResultSetMetaData meta = rs.getMetaData();
        int nCols = meta.getColumnCount();
        int nRows = 0;
        for (i = 1; i <= nCols; ++i) {
            if (i > 1) {
                this.out.print("\t");
            }
            this.out.print(meta.getColumnName(i));
        }
        this.out.println();
        while (rs.next()) {
            for (i = 1; i <= nCols; ++i) {
                if (i > 1) {
                    this.out.print("\t");
                }
                this.out.print(rs.getString(i));
            }
            this.out.println();
            ++nRows;
        }
        return nRows;
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.out, 100, "java org.apache.kylin.jdbc.QueryCLI [options] <sql-or-file>", "options:", OPTIONS, 2, 2, "");
    }

    static {
        OptionBuilder.withArgName("host:port");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription("Service endpoint, e.g. -s localhost:7070");
        OPT_SERVICE = OptionBuilder.create("s");
        OptionBuilder.withArgName(PROJECT_ARG_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription("Project name, e.g. -project learn_kylin");
        OPT_PROJECT = OptionBuilder.create(PROJECT_ARG_NAME);
        OptionBuilder.withArgName("username");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Login user name, by default -u ADMIN");
        OPT_USER = OptionBuilder.create("u");
        OptionBuilder.withArgName("password");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired(false);
        OptionBuilder.withDescription("Login password, by default -p KYLIN");
        OPT_PWD = OptionBuilder.create("p");
        OPTIONS = new Options();
        OPTIONS.addOption(OPT_SERVICE);
        OPTIONS.addOption(OPT_PROJECT);
        OPTIONS.addOption(OPT_USER);
        OPTIONS.addOption(OPT_PWD);
    }
}

