/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc;

import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.kylin.jdbc.IRemoteClient;
import org.apache.kylin.jdbc.KylinConnection;
import org.apache.kylin.jdbc.KylinPreparedStatement;
import org.apache.kylin.jdbc.KylinStatement;
import org.apache.kylin.jdbc.LoggerUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaParameter;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.AvaticaStatement;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.Meta;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.MetaImpl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.QueryState;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.AbstractCursor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.util.KylinDelegateCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinResultSet
extends AvaticaResultSet {
    private static final Logger logger = LoggerFactory.getLogger(KylinResultSet.class);
    private String queryId;
    private long resultRowCount;
    private long duration;

    public KylinResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(statement, state, signature, resultSetMetaData, timeZone, firstFrame);
        LoggerUtils.entry(logger);
        LoggerUtils.exit(logger);
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public long getResultRowCount() {
        return this.resultRowCount;
    }

    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    protected AvaticaResultSet execute() throws SQLException {
        IRemoteClient.QueryResult result;
        LoggerUtils.entry(logger);
        if (this.firstFrame != null) {
            return super.execute();
        }
        String sql = this.signature.sql;
        List<AvaticaParameter> params = this.signature.parameters;
        List<Object> paramValues = null;
        if (!(this.statement instanceof KylinPreparedStatement)) {
            params = null;
        } else if (params != null && params.size() > 0) {
            paramValues = ((KylinPreparedStatement)this.statement).getParameterJDBCValues();
        }
        String queryId = null;
        if (this.statement instanceof KylinPreparedStatement) {
            queryId = ((KylinPreparedStatement)this.statement).getQueryId();
            ((KylinPreparedStatement)this.statement).resetQueryId();
        } else if (this.statement instanceof KylinStatement) {
            queryId = ((KylinStatement)this.statement).getQueryId();
            ((KylinStatement)this.statement).resetQueryId();
        }
        IRemoteClient client = ((KylinConnection)this.statement.connection).getRemoteClient();
        HashMap<String, String> queryToggles = new HashMap<String, String>();
        int maxRows = this.statement.getMaxRows();
        queryToggles.put("ATTR_STATEMENT_MAX_ROWS", String.valueOf(maxRows));
        try {
            result = client.executeQuery(sql, params, paramValues, queryToggles, queryId);
        }
        catch (IOException e) {
            logger.error("Query failed: ", e);
            throw new SQLException(e);
        }
        this.columnMetaDataList.clear();
        this.columnMetaDataList.addAll(result.columnMeta);
        this.cursor = MetaImpl.createCursor(this.signature.cursorFactory, result.iterable);
        if (this.cursor instanceof AbstractCursor) {
            this.cursor = new KylinDelegateCursor((AbstractCursor)this.cursor);
        }
        AvaticaResultSet resultSet = super.execute2(this.cursor, this.columnMetaDataList);
        KylinResultSet kylinResultSet = (KylinResultSet)resultSet;
        kylinResultSet.setQueryId(result.queryId);
        kylinResultSet.setDuration(result.duration);
        kylinResultSet.setResultRowCount(result.resultRowCount);
        LoggerUtils.exit(logger);
        return kylinResultSet;
    }
}

