/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.DFDictionaryBuilder$;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.builder.ZKHelper$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.TaskContext$;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictionaryV2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.ExplainMode$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u000f\u001e\u0001)B\u0001B\u000f\u0001\u0003\u0006\u0004%\ta\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005y!Aq\t\u0001BC\u0002\u0013\u0005\u0001\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003J\u0011!A\u0006A!b\u0001\n\u0003I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\u0006]\u0002!\ta\u001c\u0005\u0006m\u0002!\ta\u001e\u0005\n\u0003c\u0002!\u0019!C\u0005\u0003gB\u0001\"a \u0001A\u0003%\u0011Q\u000f\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0003B\u0001\"a!\u0001A\u0003%\u00111\u0002\u0005\t\u0003\u000b\u0003A\u0011A\u000f\u0002\b\"A\u00111\u0014\u0001\u0005\u0002u\ti\n\u0003\u0006\u0002*\u0002\t\n\u0011\"\u0001\u001e\u0003WCq!!1\u0001\t\u0003\t\u0019\r\u0003\u0005\u0002T\u0002!\t!HAk\u0011\u001d\ty\u000f\u0001C\u0005\u0003cDq!a>\u0001\t\u0013\tI\u0010C\u0004\u0002~\u0002!\t!a@\b\u000f\t%Q\u0004#\u0001\u0003\f\u00191A$\bE\u0001\u0005\u001bAaA\u001c\r\u0005\u0002\t=\u0001b\u0002B\t1\u0011\u0005!1\u0003\u0005\n\u00053A\u0012\u0011!C\u0005\u00057\u00111\u0003\u0012$ES\u000e$\u0018n\u001c8bef\u0014U/\u001b7eKJT!AH\u0010\u0002\u000f\t,\u0018\u000e\u001c3fe*\u0011\u0001%I\u0001\u0006gB\f'o\u001b\u0006\u0003E\r\na!\u001a8hS:,'B\u0001\u0013&\u0003\u0015Y\u0017\u0010\\5o\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M!\u0001aK\u00198!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0019\te.\u001f*fMB\u0011!'N\u0007\u0002g)\u0011AgH\u0001\u0006kRLGn]\u0005\u0003mM\u0012Q\u0001T8h\u000bb\u0004\"\u0001\f\u001d\n\u0005ej#\u0001D*fe&\fG.\u001b>bE2,\u0017a\u00023bi\u0006\u001cX\r^\u000b\u0002yA\u0019Q(Q\"\u000e\u0003yR!a\u0010!\u0002\u0007M\fHN\u0003\u0002!K%\u0011!I\u0010\u0002\b\t\u0006$\u0018m]3u!\tiD)\u0003\u0002F}\t\u0019!k\\<\u0002\u0011\u0011\fG/Y:fi\u0002\n1a]3h+\u0005I\u0005C\u0001&R\u001b\u0005Y%B\u0001'N\u0003\u0015iw\u000eZ3m\u0015\tqu*\u0001\u0003dk\n,'B\u0001)$\u0003!iW\r^1eCR\f\u0017B\u0001*L\u00051qE)\u0019;b'\u0016<W.\u001a8u\u0003\u0011\u0019Xm\u001a\u0011)\u0005\u0011)\u0006C\u0001\u0017W\u0013\t9VFA\u0005ue\u0006t7/[3oi\u0006\u00111o]\u000b\u00025B\u0011QhW\u0005\u00039z\u0012Ab\u00159be.\u001cVm]:j_:\f1a]:!\u0003%\u0019w\u000e\u001c*fMN+G/F\u0001a!\r\tg\r[\u0007\u0002E*\u00111\rZ\u0001\u0005kRLGNC\u0001f\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0014'aA*fiB\u0011\u0011n[\u0007\u0002U*\u0011AjT\u0005\u0003Y*\u0014\u0011\u0002\u00162m\u0007>d'+\u001a4\u0002\u0015\r|GNU3g'\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0006aJ\u001cH/\u001e\t\u0003c\u0002i\u0011!\b\u0005\u0006u%\u0001\r\u0001\u0010\u0005\u0006\u000f&\u0001\r!\u0013\u0005\u00061&\u0001\rA\u0017\u0005\u0006=&\u0001\r\u0001Y\u0001\rEVLG\u000e\u001a#jGR\u001cV\r\u001e\u000b\u0003qn\u0004\"\u0001L=\n\u0005il#\u0001B+oSRDQ\u0001 \u0006A\u0002u\f\u0011d\u001a7pE\u0006dG)[2u\u0005VLG\u000e\u001a,feNLwN\\'baB9a0a\u0002\u0002\f\u0005\u0005R\"A@\u000b\t\u0005\u0005\u00111A\u0001\b[V$\u0018M\u00197f\u0015\r\t)!L\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0005\u007f\n9\u0001*Y:i\u001b\u0006\u0004\b\u0003BA\u0007\u00037qA!a\u0004\u0002\u0018A\u0019\u0011\u0011C\u0017\u000e\u0005\u0005M!bAA\u000bS\u00051AH]8pizJ1!!\u0007.\u0003\u0019\u0001&/\u001a3fM&!\u0011QDA\u0010\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011D\u0017\u0011\u00071\n\u0019#C\u0002\u0002&5\u0012A\u0001T8oO\"*!\"!\u000b\u0002<A)A&a\u000b\u00020%\u0019\u0011QF\u0017\u0003\rQD'o\\<t!\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001bI\u0006\u0011\u0011n\\\u0005\u0005\u0003s\t\u0019DA\u0006J\u001f\u0016C8-\u001a9uS>t\u0017g\u0002\u0010\u0002\f\u0005u\u0012qN\u0019\nG\u0005}\u0012qIA3\u0003\u0013*B!!\u0011\u0002DU\u0011\u00111\u0002\u0003\b\u0003\u000bJ#\u0019AA(\u0005\u0005!\u0016\u0002BA%\u0003\u0017\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA'[\u00051A\u000f\u001b:poN\fB!!\u0015\u0002XA\u0019A&a\u0015\n\u0007\u0005USFA\u0004O_RD\u0017N\\4\u0011\t\u0005e\u0013q\f\b\u0004Y\u0005m\u0013bAA/[\u00059\u0001/Y2lC\u001e,\u0017\u0002BA1\u0003G\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005uS&M\u0005$\u0003O\nI'a\u001b\u0002N9\u0019A&!\u001b\n\u0007\u00055S&M\u0003#Y5\niGA\u0003tG\u0006d\u0017-M\u0002'\u0003_\t1!Q)F+\t\t)\b\u0005\u0003\u0002x\u0005uTBAA=\u0015\r\tY\bZ\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001e\u0005e\u0014\u0001B!R\u000b\u0002\n1b\u001c:jO&t\u0017\r\\!R\u000b\u0006aqN]5hS:\fG.Q)FA\u0005I1/\u00194f\u0005VLG\u000e\u001a\u000b\u0006q\u0006%\u0015Q\u0012\u0005\u0007\u0003\u0017{\u0001\u0019\u00015\u0002\u0007I,g\rC\u0003}\u001f\u0001\u0007Q\u0010K\u0003\u0010\u0003S\t\t*M\u0004\u001f\u0003\u0017\t\u0019*!'2\u0013\r\ny$a\u0012\u0002\u0016\u0006%\u0013'C\u0012\u0002h\u0005%\u0014qSA'c\u0015\u0011C&LA7c\r1\u0013qF\u0001\u0010G\"\fgnZ3B#\u0016\u001buN\u001c4jOR!\u0011qTAS!\ra\u0013\u0011U\u0005\u0004\u0003Gk#a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003O\u0003\u0002\u0013!a\u0001\u0003?\u000b1#[:ES\u000e$()^5mI\u001aKg.[:iK\u0012\f\u0011d\u00195b]\u001e,\u0017)U#D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0016\u0016\u0005\u0003?\u000byk\u000b\u0002\u00022B!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016!C;oG\",7m[3e\u0015\r\tY,L\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA`\u0003k\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003=!\u0017n\u0019;Ck&dG-\u001a:J]\u001a|GCBA\u0006\u0003\u000b\fy\rC\u0004\u0002HJ\u0001\r!!3\u0002'\t,8m[3u!\u0006\u0014H/\u001b;j_:\u001c\u0016N_3\u0011\u00071\nY-C\u0002\u0002N6\u00121!\u00138u\u0011\u0019\t\tN\u0005a\u0001y\u0005\u0011AMZ\u0001\u0006EVLG\u000e\u001a\u000b\nq\u0006]\u0017\u0011\\An\u0003?Da!a#\u0014\u0001\u0004A\u0007bBAd'\u0001\u0007\u0011\u0011\u001a\u0005\u0007\u0003;\u001c\u0002\u0019\u0001\u001f\u0002\u001b\u00054G/\u001a:ESN$\u0018N\\2u\u0011\u001d\t\to\u0005a\u0001\u0003C\tABY;jY\u00124VM]:j_:DSaEA\u0015\u0003K\ftAHA\u0006\u0003O\fi/M\u0005$\u0003\u007f\t9%!;\u0002JEJ1%a\u001a\u0002j\u0005-\u0018QJ\u0019\u0006E1j\u0013QN\u0019\u0004M\u0005=\u0012aC4fi2{7m\u001b)bi\"$B!a\u0003\u0002t\"9\u0011Q\u001f\u000bA\u0002\u0005-\u0011\u0001\u00039bi\"t\u0015-\\3\u0002)\u001d,g.\u001a:bi\u0016\u0014U/\u001b7e-\u0016\u00148/[8o)\u0011\t\t#a?\t\r\u0005-U\u00031\u0001i\u0003\u001d9(/\u00199D_2$BA!\u0001\u0003\bA\u0019QHa\u0001\n\u0007\t\u0015aH\u0001\u0004D_2,XN\u001c\u0005\u0007\u0003\u00173\u0002\u0019\u00015\u0002'\u00113E)[2uS>t\u0017M]=Ck&dG-\u001a:\u0011\u0005ED2c\u0001\r,oQ\u0011!1B\u0001\u001aO\u0016$H*\u0019;fgR$\u0015n\u0019;Ck&dGMV3sg&|g\u000e\u0006\u0004\u0002\"\tU!q\u0003\u0005\u0006\u000fj\u0001\r!\u0013\u0005\u0007\u0003\u0017S\u0002\u0019\u00015\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005;\u0001B!a\u001e\u0003 %!!\u0011EA=\u0005\u0019y%M[3di\u0002")
public class DFDictionaryBuilder
implements LogEx,
scala.Serializable {
    private final Dataset<Row> dataset;
    private final transient NDataSegment seg;
    private final SparkSession ss;
    private final Set<TblColRef> colRefSet;
    private final String AQE;
    private final String originalAQE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static long getLatestDictBuildVersion(NDataSegment nDataSegment, TblColRef tblColRef) {
        return DFDictionaryBuilder$.MODULE$.getLatestDictBuildVersion(nDataSegment, tblColRef);
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> dataset() {
        return this.dataset;
    }

    public NDataSegment seg() {
        return this.seg;
    }

    public SparkSession ss() {
        return this.ss;
    }

    public Set<TblColRef> colRefSet() {
        return this.colRefSet;
    }

    public void buildDictSet(HashMap<String, Object> globalDictBuildVersionMap) throws IOException {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.colRefSet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)col -> {
            this.safeBuild(col, (HashMap<String, Object>)globalDictBuildVersionMap);
            return BoxedUnit.UNIT;
        });
        this.changeAQEConfig(true);
    }

    private String AQE() {
        return this.AQE;
    }

    private String originalAQE() {
        return this.originalAQE;
    }

    public void safeBuild(TblColRef ref, HashMap<String, Object> globalDictBuildVersionMap) throws IOException {
        String sourceColumn = ref.getIdentity();
        ZKHelper$.MODULE$.tryZKJaasConfiguration(this.ss());
        Lock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().getLockForCurrentThread(this.getLockPath(sourceColumn));
        lock.lock();
        try {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Calculate bucket size for dict ").append(sourceColumn).toString());
            Dataset dictColDistinct = this.dataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.wrapCol(ref)})).distinct();
            long resizeBuildVersion = this.generateBuildVersion(ref);
            this.ss().sparkContext().setJobDescription(new StringBuilder(31).append("Calculate bucket size for dict ").append(sourceColumn).toString());
            int bucketPartitionSize = BoxesRunTime.unboxToInt(this.logTime(new StringBuilder(28).append("calculating bucket size for ").append(sourceColumn).toString(), this.logTime$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DictionaryBuilderHelper.calculateBucketSize(this.seg(), ref, (Dataset<Row>)dictColDistinct, Predef$.MODULE$.long2Long(resizeBuildVersion))));
            long buildVersion = this.generateBuildVersion(ref);
            globalDictBuildVersionMap.put((Object)sourceColumn, (Object)BoxesRunTime.boxToLong((long)buildVersion));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Start to build global dict ").append(sourceColumn).append(" with version: ").append(buildVersion).toString());
            this.build(ref, bucketPartitionSize, (Dataset<Row>)dictColDistinct, buildVersion);
        }
        finally {
            lock.unlock();
        }
    }

    public boolean changeAQEConfig(boolean isDictBuildFinished) {
        if (!this.seg().getConfig().isGlobalDictAQEEnabled() && !isDictBuildFinished) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Temporarily Close AQE for dict build job");
            this.ss().conf().set(this.AQE(), false);
            return false;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Restore AQE to its initial config: ").append(this.originalAQE()).toString());
        this.ss().conf().set(this.AQE(), this.originalAQE());
        return new StringOps(Predef$.MODULE$.augmentString(this.originalAQE())).toBoolean();
    }

    public boolean changeAQEConfig$default$1() {
        return false;
    }

    public String dictBuilderInfo(int bucketPartitionSize, Dataset<Row> df) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(289).append("\n       |==========================[DICT REPARTITION INFO]===============================\n       |Partition Size :").append(df.rdd().getNumPartitions()).append("\n       |Bucket Partition Size: ").append(bucketPartitionSize).append("\n       |AQE Enabled: ").append(this.ss().conf().get(this.AQE())).append("\n       |Physical Plan:\n ").append(df.queryExecution().explainString(ExplainMode$.MODULE$.fromString(ExtendedMode$.MODULE$.name()))).append("\n       |==========================[DICT REPARTITION INFO]===============================\n      ").toString())).stripMargin();
    }

    public void build(TblColRef ref, int bucketPartitionSize, Dataset<Row> afterDistinct, long buildVersion) throws IOException {
        this.logTime(new StringBuilder(36).append("building global dictionaries V2 for ").append(ref.getIdentity()).toString(), this.logTime$default$2(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            block0: {
                NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(this.seg().getProject(), ref.getTable(), ref.getName(), this.seg().getConfig().getHdfsWorkingDirectory(), buildVersion);
                globalDict.prepareWrite();
                Broadcast broadcastDict = this.ss().sparkContext().broadcast((Object)globalDict, ClassTag$.MODULE$.apply(NGlobalDictionaryV2.class));
                this.changeAQEConfig(false);
                this.ss().sparkContext().setJobDescription(new StringBuilder(25).append("Build dict ").append(ref.getIdentity()).append(" with version ").append(buildVersion).toString());
                Column dictCol = functions$.MODULE$.col(((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])afterDistinct.schema().fields())).head()).name());
                Dataset afterDistinctRepartition = afterDistinct.filter(dictCol.isNotNull()).repartition(bucketPartitionSize, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dictCol}));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> this.dictBuilderInfo(bucketPartitionSize, (Dataset<Row>)afterDistinctRepartition));
                afterDistinctRepartition.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
                    DFDictionaryBuilder.$anonfun$build$3(this, ref, broadcastDict, iter);
                    return BoxedUnit.UNIT;
                });
                globalDict.writeMetaDict(bucketPartitionSize, this.seg().getConfig().getGlobalDictV2MaxVersions(), this.seg().getConfig().getGlobalDictV2VersionTTL());
                if (!this.seg().getConfig().isGlobalDictCheckEnabled()) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Start to check the correctness of the global dict, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
                NGlobalDictionaryV2 latestGD = new NGlobalDictionaryV2(this.seg().getProject(), ref.getTable(), ref.getName(), this.seg().getConfig().getHdfsWorkingDirectory(), buildVersion);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), globalDict.getMetaInfo().getBucketSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bid -> {
                    Object2LongMap dMap = latestGD.loadBucketDictionary(bid).getAbsoluteDictMap();
                    long vdCount = dMap.values().stream().distinct().count();
                    long kdCount = dMap.keySet().stream().distinct().count();
                    if (kdCount != vdCount) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Global dict correctness check failed, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
                        throw new NoRetryException(new StringBuilder(78).append("Global dict build error, bucket: ").append(bid).append(", key distinct count:").append(kdCount).append(", value distinct count: ").append(vdCount).toString());
                    }
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Global dict correctness check completed, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
            }
            return this.changeAQEConfig(true);
        });
    }

    private String getLockPath(String pathName) {
        return new StringBuilder(24).append("/").append(this.seg().getProject()).append("/dict/global_dict").append("/").append(pathName).append("/lock").toString();
    }

    /*
     * WARNING - void declaration
     */
    private long generateBuildVersion(TblColRef ref) {
        void var2_2;
        long buildVersion = System.currentTimeMillis();
        long latestDictVersion = DFDictionaryBuilder$.MODULE$.getLatestDictBuildVersion(this.seg(), ref);
        return latestDictVersion != -1L && buildVersion <= latestDictVersion ? latestDictVersion + 1L : var2_2;
    }

    public Column wrapCol(TblColRef ref) {
        String colName = NSparkCubingUtil.convertFromDotWithBackTick((String)ref.getBackTickIdentity());
        return functions$.MODULE$.expr(colName).cast((DataType)StringType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$build$3(DFDictionaryBuilder $this, TblColRef ref$2, Broadcast broadcastDict$1, Iterator iter) {
        int partitionID = TaskContext$.MODULE$.get().partitionId();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Build partition dict col: ").append(ref$2.getIdentity()).append(", partitionId: ").append(partitionID).toString());
        NGlobalDictionaryV2 broadcastGlobalDict = (NGlobalDictionaryV2)broadcastDict$1.value();
        NBucketDictionary bucketDict = broadcastGlobalDict.loadBucketDictionary(partitionID);
        iter.foreach((Function1 & Serializable & scala.Serializable)r -> {
            bucketDict.addRelativeValue(r.getString(0));
            return BoxedUnit.UNIT;
        });
        bucketDict.saveBucketDict(partitionID);
    }

    public DFDictionaryBuilder(Dataset<Row> dataset, NDataSegment seg, SparkSession ss, Set<TblColRef> colRefSet) {
        this.dataset = dataset;
        this.seg = seg;
        this.ss = ss;
        this.colRefSet = colRefSet;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.AQE = "spark.sql.adaptive.enabled";
        this.originalAQE = ss.conf().get(this.AQE());
    }
}

