/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.util.Locale;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnarSplitReader<KEYIN, VALUEIN>
extends RecordReader {
    private static Logger logger = LoggerFactory.getLogger(ColumnarSplitReader.class);
    protected String cubeName;
    protected String segmentName;
    protected CubeInstance cube;
    protected CubeDesc cubeDesc;
    protected CubeSegment cubeSegment;

    public ColumnarSplitReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.initialize(inputSplit, context);
    }

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        if (!(split instanceof FileSplit)) {
            throw new IllegalArgumentException("Only compatible with FileSplits.");
        }
        logger.debug("CFG_Cube_Name: cube.name");
        this.cubeName = context.getConfiguration().get("cube.name").toUpperCase(Locale.ROOT);
        this.segmentName = context.getConfiguration().get("cube.segment.name").toUpperCase(Locale.ROOT);
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)config);
        this.cube = cubeManager.getCube(this.cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.cubeSegment = this.cube.getSegment(this.segmentName, SegmentStatusEnum.NEW);
    }
}

