/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.streaming;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.DictionarySerializer;
import org.apache.kylin.engine.mr.streaming.ColumnarSplitReader;
import org.apache.kylin.engine.mr.streaming.DictsReader;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableMap;
import org.apache.kylin.shaded.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnarSplitDictReader
extends ColumnarSplitReader {
    private static Logger logger = LoggerFactory.getLogger(ColumnarSplitDictReader.class);
    private Iterator<Map.Entry<String, Dictionary>> itr;
    private DictsReader dictsReader;
    private Text currentKey;
    private Text currentValue;
    private AtomicInteger readCount;

    public ColumnarSplitDictReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        super(split, context);
        this.init(split, context);
    }

    public float getProgress() throws IOException, InterruptedException {
        return -1.0f;
    }

    public void init(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        FileSplit fSplit = (FileSplit)split;
        Path path = fSplit.getPath();
        this.dictsReader = new DictsReader(path, fs);
        ImmutableMap<String, Dictionary> dimensionDictMap = this.dictsReader.readDicts();
        ImmutableSet set = dimensionDictMap.entrySet();
        this.itr = set.iterator();
        this.readCount = new AtomicInteger(0);
        logger.info("Reader for dictionary reader initialized. ");
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        if (!this.itr.hasNext()) {
            return false;
        }
        Map.Entry<String, Dictionary> dimensionDict = this.itr.next();
        this.currentKey = new Text(dimensionDict.getKey());
        byte[] dictBytes = DictionarySerializer.serialize((Dictionary)dimensionDict.getValue()).array();
        this.currentValue = new Text(dictBytes);
        if (this.readCount.get() % 3 == 0) {
            logger.debug("3 more dict read. ");
        }
        this.readCount.getAndIncrement();
        return true;
    }

    public Text getCurrentKey() throws IOException, InterruptedException {
        return this.currentKey;
    }

    public Text getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public void close() throws IOException {
        this.dictsReader.close();
    }
}

