/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.engine.mr.ByteArrayWritable;
import org.apache.kylin.engine.mr.KylinReducer;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureAggregators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemCuboidReducer
extends KylinReducer<ByteArrayWritable, ByteArrayWritable, Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger(InMemCuboidReducer.class);
    private BufferedMeasureCodec codec;
    private MeasureAggregators aggs;
    private Object[] input;
    private Object[] result;
    private int vcounter;
    private Text outputKey;
    private Text outputValue;

    @Override
    protected void doSetup(Reducer.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
        KylinConfig config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        String cubeName = context.getConfiguration().get("cube.name").toUpperCase(Locale.ROOT);
        CubeInstance cube = CubeManager.getInstance((KylinConfig)config).getCube(cubeName);
        CubeDesc cubeDesc = cube.getDescriptor();
        List measuresDescs = cubeDesc.getMeasures();
        this.codec = new BufferedMeasureCodec((Collection)measuresDescs);
        this.aggs = new MeasureAggregators((Collection)measuresDescs);
        this.input = new Object[measuresDescs.size()];
        this.result = new Object[measuresDescs.size()];
        this.outputKey = new Text();
        this.outputValue = new Text();
    }

    @Override
    public void doReduce(ByteArrayWritable key, Iterable<ByteArrayWritable> values, Reducer.Context context) throws IOException, InterruptedException {
        this.aggs.reset();
        for (ByteArrayWritable value : values) {
            if (this.vcounter++ % 100000 == 0) {
                logger.info("Handling value with ordinal (This is not KV number!): " + this.vcounter);
            }
            this.codec.decode(value.asBuffer(), this.input);
            this.aggs.aggregate(this.input);
        }
        this.aggs.collectStates(this.result);
        this.outputKey.set(key.array(), key.offset(), key.length());
        ByteBuffer valueBuf = this.codec.encode(this.result);
        this.outputValue.set(valueBuf.array(), 0, valueBuf.position());
        context.write((Object)this.outputKey, (Object)this.outputValue);
    }
}

