/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.dict.ShrunkenDictionary;
import org.apache.kylin.dict.ShrunkenDictionaryBuilder;
import org.apache.kylin.engine.EngineFactory;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.KylinMapper;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.DictionaryGetterUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;

public class ExtractDictionaryFromGlobalMapper<KEYIN, Object>
extends KylinMapper<KEYIN, Object, Text, Text> {
    private String cubeName;
    private CubeDesc cubeDesc;
    private CubeInstance cube;
    private CubeSegment cubeSeg;
    private IMRInput.IMRTableInputFormat flatTableInputFormat;
    private CubeJoinedFlatTableEnrich intermediateTableDesc;
    private List<TblColRef> globalColumns;
    private int[] globalColumnIndex;
    private List<Set<String>> globalColumnValues;
    private String splitKey;
    private KylinConfig config;

    @Override
    protected void doSetup(Mapper.Context context) throws IOException {
        Configuration conf = context.getConfiguration();
        this.bindCurrentConfiguration(conf);
        this.config = AbstractHadoopJob.loadKylinPropsAndMetadata();
        this.cubeName = conf.get("cube.name");
        this.cube = CubeManager.getInstance((KylinConfig)this.config).getCube(this.cubeName);
        this.cubeDesc = this.cube.getDescriptor();
        this.cubeSeg = this.cube.getSegmentById(conf.get("cube.segment.id"));
        this.flatTableInputFormat = MRUtil.getBatchCubingInputSide(this.cubeSeg).getFlatTableInputFormat();
        this.intermediateTableDesc = new CubeJoinedFlatTableEnrich(EngineFactory.getJoinedFlatTableDesc((CubeSegment)this.cubeSeg), this.cubeDesc);
        this.globalColumns = this.cubeDesc.getAllGlobalDictColumns();
        this.globalColumnIndex = new int[this.globalColumns.size()];
        this.globalColumnValues = Lists.newArrayListWithExpectedSize((int)this.globalColumns.size());
        for (int i = 0; i < this.globalColumns.size(); ++i) {
            int columnIndexOnFlatTbl;
            TblColRef colRef = this.globalColumns.get(i);
            this.globalColumnIndex[i] = columnIndexOnFlatTbl = this.intermediateTableDesc.getColumnIndex(colRef);
            this.globalColumnValues.add(Sets.newHashSet());
        }
        this.splitKey = DictionaryGetterUtil.getInputSplitSignature(this.cubeSeg, context.getInputSplit());
    }

    @Override
    public void doMap(KEYIN key, Object record, Mapper.Context context) throws IOException, InterruptedException {
        Collection<String[]> rowCollection = this.flatTableInputFormat.parseMapperInput(record);
        for (String[] row : rowCollection) {
            for (int i = 0; i < this.globalColumnIndex.length; ++i) {
                String fieldValue = row[this.globalColumnIndex[i]];
                if (fieldValue == null) continue;
                this.globalColumnValues.get(i).add(fieldValue);
            }
        }
    }

    @Override
    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        Path outputDirBase = new Path(context.getConfiguration().get("mapreduce.output.fileoutputformat.outputdir"));
        Map globalDictionaryMap = this.cubeSeg.buildGlobalDictionaryMap(this.globalColumns.size());
        ShrunkenDictionary.StringValueSerializer strValueSerializer = new ShrunkenDictionary.StringValueSerializer();
        for (int i = 0; i < this.globalColumns.size(); ++i) {
            ArrayList colDistinctValues = Lists.newArrayList((Iterable)this.globalColumnValues.get(i));
            if (colDistinctValues.size() == 0) continue;
            Collections.sort(colDistinctValues);
            ShrunkenDictionaryBuilder dictBuilder = new ShrunkenDictionaryBuilder((Dictionary)globalDictionaryMap.get(this.globalColumns.get(i)));
            for (String colValue : colDistinctValues) {
                dictBuilder.addValue((Object)colValue);
            }
            ShrunkenDictionary shrunkenDict = dictBuilder.build((ShrunkenDictionary.ValueSerializer)strValueSerializer);
            Path colDictDir = new Path(outputDirBase, this.globalColumns.get(i).getIdentity());
            if (!fs.exists(colDictDir)) {
                fs.mkdirs(colDictDir);
            }
            try (FSDataOutputStream dos = fs.create(new Path(colDictDir, this.splitKey));){
                shrunkenDict.write((DataOutput)dos);
                continue;
            }
        }
    }
}

