/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeBuildTypeEnum;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.job.JobSearchResult;
import org.apache.kylin.job.common.ShellExecutable;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.constant.JobStepStatusEnum;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.CheckpointExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.Output;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobInfoConverter {
    private static final Logger logger = LoggerFactory.getLogger(JobInfoConverter.class);

    public static JobInstance parseToJobInstanceQuietly(CubingJob job, Map<String, Output> outputs) {
        try {
            return JobInfoConverter.parseToJobInstance(job, outputs);
        }
        catch (Exception e) {
            logger.error("Failed to parse job instance: uuid={}", (Object)job, (Object)e);
            return null;
        }
    }

    public static JobInstance parseToJobInstanceQuietly(CheckpointExecutable job, Map<String, Output> outputs) {
        try {
            return JobInfoConverter.parseToJobInstance(job, outputs);
        }
        catch (Exception e) {
            logger.error("Failed to parse job instance: uuid={}", (Object)job, (Object)e);
            return null;
        }
    }

    public static JobInstance parseToJobInstance(CubingJob job, Map<String, Output> outputs) {
        String cubeName;
        if (job == null) {
            logger.warn("job is null.");
            return null;
        }
        Output output = outputs.get(job.getId());
        if (output == null) {
            logger.warn("job output is null.");
            return null;
        }
        CubingJob cubeJob = job;
        String displayCubeName = cubeName = CubingExecutableUtil.getCubeName(cubeJob.getParams());
        try {
            CubeInstance cube = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube(cubeName);
            if (cube != null) {
                cubeName = cube.getName();
                displayCubeName = cube.getDisplayName();
            }
        }
        catch (Exception e) {
            logger.warn("Fail to get cube instance for {}.", (Object)cubeName);
        }
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setProjectName(cubeJob.getProjectName());
        result.setRelatedCube(cubeName);
        result.setDisplayCubeName(displayCubeName);
        result.setRelatedSegment(CubingExecutableUtil.getSegmentId(cubeJob.getParams()));
        result.setRelatedSegmentName(CubingExecutableUtil.getSegmentName(cubeJob.getParams()));
        result.setLastModified(output.getLastModified());
        result.setSubmitter(job.getSubmitter());
        result.setUuid(job.getId());
        result.setType(CubeBuildTypeEnum.BUILD);
        result.setStatus(JobInfoConverter.parseToJobStatus(output.getState()));
        result.setBuildInstance(AbstractExecutable.getBuildInstance((Output)output));
        result.setMrWaiting(AbstractExecutable.getExtraInfoAsLong((Output)output, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)output));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)output));
        result.setExecInterruptTime(AbstractExecutable.getInterruptTime((Output)output));
        result.setDuration(AbstractExecutable.getDuration((long)result.getExecStartTime(), (long)result.getExecEndTime(), (long)result.getExecInterruptTime()) / 1000L);
        for (int i = 0; i < job.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)job.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, outputs.get(task.getId())));
        }
        return result;
    }

    public static JobInstance parseToJobInstance(CheckpointExecutable job, Map<String, Output> outputs) {
        if (job == null) {
            logger.warn("job is null.");
            return null;
        }
        Output output = outputs.get(job.getId());
        if (output == null) {
            logger.warn("job output is null.");
            return null;
        }
        JobInstance result = new JobInstance();
        result.setName(job.getName());
        result.setProjectName(job.getProjectName());
        result.setRelatedCube(CubingExecutableUtil.getCubeName(job.getParams()));
        result.setDisplayCubeName(CubingExecutableUtil.getCubeName(job.getParams()));
        result.setLastModified(output.getLastModified());
        result.setSubmitter(job.getSubmitter());
        result.setUuid(job.getId());
        result.setType(CubeBuildTypeEnum.CHECKPOINT);
        result.setStatus(JobInfoConverter.parseToJobStatus(output.getState()));
        result.setBuildInstance(AbstractExecutable.getBuildInstance((Output)output));
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)output));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)output));
        result.setExecInterruptTime(AbstractExecutable.getInterruptTime((Output)output));
        result.setDuration(AbstractExecutable.getDuration((long)result.getExecStartTime(), (long)result.getExecEndTime(), (long)result.getExecInterruptTime()) / 1000L);
        for (int i = 0; i < job.getTasks().size(); ++i) {
            AbstractExecutable task = (AbstractExecutable)job.getTasks().get(i);
            result.addStep(JobInfoConverter.parseToJobStep(task, i, outputs.get(task.getId())));
        }
        return result;
    }

    public static JobInstance.JobStep parseToJobStep(AbstractExecutable task, int i, Output stepOutput) {
        JobInstance.JobStep result = new JobInstance.JobStep();
        result.setId(task.getId());
        result.setName(task.getName());
        result.setSequenceID(i);
        if (stepOutput == null) {
            logger.warn("Cannot found output for task: id={}", (Object)task.getId());
            return result;
        }
        result.setStatus(JobInfoConverter.parseToJobStepStatus(stepOutput.getState()));
        for (Map.Entry entry : stepOutput.getExtra().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            result.putInfo((String)entry.getKey(), (String)entry.getValue());
        }
        result.setExecStartTime(AbstractExecutable.getStartTime((Output)stepOutput));
        result.setExecEndTime(AbstractExecutable.getEndTime((Output)stepOutput));
        if (task instanceof ShellExecutable) {
            result.setExecCmd(((ShellExecutable)task).getCmd());
        }
        if (task instanceof MapReduceExecutable) {
            result.setExecCmd(((MapReduceExecutable)task).getMapReduceParams());
            result.setExecWaitTime(AbstractExecutable.getExtraInfoAsLong((Output)stepOutput, (String)"mapReduceWaitTime", (long)0L) / 1000L);
        }
        if (task instanceof HadoopShellExecutable) {
            result.setExecCmd(((HadoopShellExecutable)task).getJobParams());
        }
        return result;
    }

    public static JobStatusEnum parseToJobStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStatusEnum.FINISHED;
            }
            case STOPPED: {
                return JobStatusEnum.STOPPED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }

    public static JobStepStatusEnum parseToJobStepStatus(ExecutableState state) {
        switch (state) {
            case READY: {
                return JobStepStatusEnum.PENDING;
            }
            case RUNNING: {
                return JobStepStatusEnum.RUNNING;
            }
            case ERROR: {
                return JobStepStatusEnum.ERROR;
            }
            case DISCARDED: {
                return JobStepStatusEnum.DISCARDED;
            }
            case SUCCEED: {
                return JobStepStatusEnum.FINISHED;
            }
            case STOPPED: {
                return JobStepStatusEnum.STOPPED;
            }
        }
        throw new RuntimeException("invalid state:" + state);
    }

    public static JobSearchResult parseToJobSearchResult(DefaultChainedExecutable job, Map<String, ExecutableOutputPO> outputs) {
        if (job == null) {
            logger.warn("job is null.");
            return null;
        }
        ExecutableOutputPO output = outputs.get(job.getId());
        if (output == null) {
            logger.warn("job output is null.");
            return null;
        }
        JobSearchResult result = new JobSearchResult();
        String cubeName = CubingExecutableUtil.getCubeName(job.getParams());
        if (cubeName == null) {
            cubeName = job.getParam("model_name");
        } else {
            CubeInstance cube = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getCube(cubeName);
            if (cube != null) {
                cubeName = cube.getDisplayName();
            }
        }
        result.setCubeName(cubeName);
        result.setId(job.getId());
        result.setJobName(job.getName());
        result.setLastModified(output.getLastModified());
        result.setJobStatus(JobInfoConverter.parseToJobStatus(job.getStatus()));
        return result;
    }
}

