/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.CubeJoinedFlatTableEnrich;
import org.apache.kylin.cube.util.KeyValueBuilder;
import org.apache.kylin.job.JoinedFlatTable;
import org.apache.kylin.measure.BufferedMeasureCodec;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCuboidBuilder
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(BaseCuboidBuilder.class);
    protected KylinConfig kylinConfig;
    protected CubeDesc cubeDesc;
    protected CubeSegment cubeSegment;
    protected CubeJoinedFlatTableEnrich intermediateTableDesc;
    protected MeasureIngester<?>[] aggrIngesters;
    protected Map<TblColRef, Dictionary<String>> dictionaryMap;
    protected AbstractRowKeyEncoder rowKeyEncoder;
    protected List<MeasureDesc> measureDescList;
    protected BufferedMeasureCodec measureCodec;
    protected KeyValueBuilder kvBuilder;

    public BaseCuboidBuilder(KylinConfig kylinConfig, CubeDesc cubeDesc, CubeSegment cubeSegment, CubeJoinedFlatTableEnrich intermediateTableDesc, AbstractRowKeyEncoder rowKeyEncoder, MeasureIngester<?>[] aggrIngesters, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.kylinConfig = kylinConfig;
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.intermediateTableDesc = intermediateTableDesc;
        this.dictionaryMap = dictionaryMap;
        this.rowKeyEncoder = rowKeyEncoder;
        this.aggrIngesters = aggrIngesters;
        this.measureDescList = cubeDesc.getMeasures();
        this.measureCodec = new BufferedMeasureCodec(this.measureDescList);
        this.kvBuilder = new KeyValueBuilder(intermediateTableDesc);
        this.checkHiveGlobalDictionaryColumn();
    }

    public BaseCuboidBuilder(KylinConfig kylinConfig, CubeDesc cubeDesc, CubeSegment cubeSegment, CubeJoinedFlatTableEnrich intermediateTableDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
        this.kylinConfig = kylinConfig;
        this.cubeDesc = cubeDesc;
        this.cubeSegment = cubeSegment;
        this.intermediateTableDesc = intermediateTableDesc;
        this.dictionaryMap = dictionaryMap;
        Cuboid baseCuboid = Cuboid.getBaseCuboid((CubeDesc)cubeDesc);
        this.rowKeyEncoder = AbstractRowKeyEncoder.createInstance((CubeSegment)cubeSegment, (Cuboid)baseCuboid);
        this.measureDescList = cubeDesc.getMeasures();
        this.aggrIngesters = MeasureIngester.create(this.measureDescList);
        this.measureCodec = new BufferedMeasureCodec(this.measureDescList);
        this.kvBuilder = new KeyValueBuilder(intermediateTableDesc);
        this.checkHiveGlobalDictionaryColumn();
    }

    public byte[] buildKey(String[] flatRow) {
        String[] colKeys = this.kvBuilder.buildKey(flatRow);
        return this.rowKeyEncoder.encode(colKeys);
    }

    public ByteBuffer buildValue(String[] flatRow) {
        return this.measureCodec.encode(this.buildValueObjects(flatRow));
    }

    public Object[] buildValueObjects(String[] flatRow) {
        Object[] measures = new Object[this.cubeDesc.getMeasures().size()];
        for (int i = 0; i < measures.length; ++i) {
            String[] colValues = this.kvBuilder.buildValueOf(i, flatRow);
            MeasureDesc measure = this.measureDescList.get(i);
            measures[i] = this.aggrIngesters[i].valueOf(colValues, measure, this.dictionaryMap);
        }
        return measures;
    }

    public void resetAggrs() {
        for (int i = 0; i < this.cubeDesc.getMeasures().size(); ++i) {
            this.aggrIngesters[i].reset();
        }
    }

    private void checkHiveGlobalDictionaryColumn() {
        HashSet mrDictColumnSet = new HashSet();
        if (this.kylinConfig.getMrHiveDictColumns() != null) {
            Collections.addAll(mrDictColumnSet, this.kylinConfig.getMrHiveDictColumns());
        }
        for (MeasureDesc measure : this.measureDescList) {
            FunctionDesc functionDesc;
            TblColRef colRef;
            if (!measure.getFunction().getExpression().equalsIgnoreCase("COUNT_DISTINCT") || !mrDictColumnSet.contains(JoinedFlatTable.colName((TblColRef)(colRef = (TblColRef)(functionDesc = measure.getFunction()).getParameter().getColRefs().get(0)), (boolean)true))) continue;
            functionDesc.setMrDict(true);
            logger.info("Enable hive global dictionary for {}", (Object)colRef);
            measure.setFunction(functionDesc);
        }
    }
}

