/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidUtil;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.LookupMaterializeContext;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BaseCuboidJob;
import org.apache.kylin.engine.mr.steps.InMemCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCubingJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchCubingJobBuilder2.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput2.IMRBatchCubingOutputSide2 outputSide;

    public BatchCubingJobBuilder2(CubeSegment newSegment, String submitter, Integer priorityOffset) {
        super(newSegment, submitter, priorityOffset);
        this.inputSide = MRUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = MRUtil.getBatchCubingOutputSide2(this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to BUILD segment {}", (Object)this.seg);
        CubingJob result = CubingJob.createBuildJob(this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        this.buildHiveGlobalDictionaryByMR(result, jobId);
        result.addTask(this.createFactDistinctColumnsStep(jobId));
        if (this.isEnableUHCDictStep()) {
            result.addTask(this.createBuildUHCDictStep(jobId));
        }
        result.addTask(this.createBuildDictionaryStep(jobId));
        result.addTask(this.createSaveStatisticsStep(jobId));
        LookupMaterializeContext lookupMaterializeContext = this.addMaterializeLookupTableSteps(result);
        this.outputSide.addStepPhase2_BuildDictionary(result);
        if (this.seg.getCubeDesc().isShrunkenDictFromGlobalEnabled()) {
            result.addTask(this.createExtractDictionaryFromGlobalJob(jobId));
        }
        this.addLayerCubingSteps(result, jobId, cuboidRootPath);
        this.addInMemCubingSteps(result, jobId, cuboidRootPath);
        this.outputSide.addStepPhase3_BuildCube(result);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId, lookupMaterializeContext));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        result.setPriorityBasedOnPriorityOffset(this.priorityOffset);
        result.getTasks().forEach(task -> task.setPriorityBasedOnPriorityOffset(this.priorityOffset));
        return result;
    }

    @Override
    public boolean isEnableUHCDictStep() {
        if (!this.config.getConfig().isBuildUHCDictWithMREnabled()) {
            return false;
        }
        List uhcColumns = this.seg.getCubeDesc().getAllUHCColumns();
        return uhcColumns.size() != 0;
    }

    protected void addLayerCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        int maxLevel = CuboidUtil.getLongestDepth((Set)this.seg.getCuboidScheduler().getAllCuboidIds());
        result.addTask(this.createBaseCuboidStep(BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, 0), jobId));
        for (int i = 1; i <= maxLevel; ++i) {
            result.addTask(this.createNDimensionCuboidStep(BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i - 1), BatchCubingJobBuilder2.getCuboidOutputPathsByLevel(cuboidRootPath, i), i, jobId));
        }
    }

    protected void addInMemCubingSteps(CubingJob result, String jobId, String cuboidRootPath) {
        MapReduceExecutable cubeStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd, "inmem");
        cubeStep.setName("Build Cube In-Mem");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidRootPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Cube_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        if (this.seg.getCubeDesc().isShrunkenDictFromGlobalEnabled()) {
            BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "shrunkenDictPath", this.getShrunkenDictionaryPath(jobId));
        }
        cubeStep.setMapReduceParams(cmd.toString());
        cubeStep.setMapReduceJobClass(this.getInMemCuboidJob());
        result.addTask(cubeStep);
    }

    protected Class<? extends AbstractHadoopJob> getInMemCuboidJob() {
        return InMemCuboidJob.class;
    }

    private MapReduceExecutable createBaseCuboidStep(String cuboidOutputPath, String jobId) {
        MapReduceExecutable baseCuboidStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        baseCuboidStep.setName("Build Base Cuboid");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", "FLAT_TABLE");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", cuboidOutputPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_Base_Cuboid_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "0");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        if (this.seg.getCubeDesc().isShrunkenDictFromGlobalEnabled()) {
            BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "shrunkenDictPath", this.getShrunkenDictionaryPath(jobId));
        }
        baseCuboidStep.setMapReduceParams(cmd.toString());
        baseCuboidStep.setMapReduceJobClass(this.getBaseCuboidJob());
        return baseCuboidStep;
    }

    protected Class<? extends AbstractHadoopJob> getBaseCuboidJob() {
        return BaseCuboidJob.class;
    }

    private MapReduceExecutable createNDimensionCuboidStep(String parentPath, String outputPath, int level, String jobId) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid : level " + level);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "input", parentPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "output", outputPath);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "level", "" + level);
        BatchCubingJobBuilder2.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(this.getNDCuboidJob());
        return ndCuboidStep;
    }

    protected void buildHiveGlobalDictionaryByMR(CubingJob result, String jobId) {
        KylinConfig dictConfig = this.seg.getConfig();
        String[] mrHiveDictColumnExcludeRef = dictConfig.getMrHiveDictColumnsExcludeRefColumns();
        String[] mrHiveDictColumns = dictConfig.getMrHiveDictColumns();
        if (Objects.nonNull(mrHiveDictColumnExcludeRef) && mrHiveDictColumnExcludeRef.length > 0 && !"".equals(mrHiveDictColumnExcludeRef[0])) {
            result.addTask(this.createBuildGlobalHiveDictPartBuildJob(jobId));
            result.addTask(this.createBuildGlobalHiveDictTotalBuildJob(jobId));
        }
        if (Objects.nonNull(mrHiveDictColumns) && mrHiveDictColumns.length > 0 && !"".equals(mrHiveDictColumns[0])) {
            this.inputSide.addStepPhase_ReplaceFlatTableGlobalColumnValue(result);
        }
    }

    protected Class<? extends AbstractHadoopJob> getNDCuboidJob() {
        return NDCuboidJob.class;
    }
}

