/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateCubeInfoAfterBuildStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateCubeInfoAfterBuildStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = cubeManager.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment segment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        CubingJob cubingJob = (CubingJob)this.getManager().getJob(CubingExecutableUtil.getCubingJobId(this.getParams()));
        long sourceCount = cubingJob.findSourceRecordCount();
        long sourceSizeBytes = cubingJob.findSourceSizeBytes();
        long cubeSizeBytes = cubingJob.findCubeSizeBytes();
        segment.setLastBuildJobID(CubingExecutableUtil.getCubingJobId(this.getParams()));
        segment.setLastBuildTime(System.currentTimeMillis());
        segment.setSizeKB(cubeSizeBytes / 1024L);
        segment.setInputRecords(sourceCount);
        segment.setInputRecordsSize(sourceSizeBytes);
        try {
            if (segment.isSourceOffsetsOn()) {
                this.updateTimeRange(segment);
            }
            cubeManager.promoteNewlyBuiltSegments(cube, segment);
            return new ExecuteResult(ExecuteResult.State.SUCCEED, "succeed");
        }
        catch (IOException e) {
            logger.error("fail to update cube after build", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTimeRange(CubeSegment segment) throws IOException {
        long maxValue;
        long minValue;
        TblColRef partitionCol = segment.getCubeDesc().getModel().getPartitionDesc().getPartitionDateColumnRef();
        if (partitionCol == null) {
            return;
        }
        String factColumnsInputPath = (String)this.getParams().get("output.path");
        Path colDir = new Path(factColumnsInputPath, partitionCol.getIdentity());
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        Path outputFile = HadoopUtil.getFilterOnlyPath((FileSystem)fs, (Path)colDir, (String)(partitionCol.getName() + ".pci"));
        if (outputFile == null) {
            throw new IOException("fail to find the partition file in base dir: " + colDir);
        }
        FSDataInputStream is = null;
        BufferedReader bufferedReader = null;
        InputStreamReader isr = null;
        try {
            is = fs.open(outputFile);
            isr = new InputStreamReader((InputStream)is);
            bufferedReader = new BufferedReader(isr);
            minValue = Long.parseLong(bufferedReader.readLine());
            maxValue = Long.parseLong(bufferedReader.readLine());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((Reader)bufferedReader);
        logger.info("updateTimeRange step. minValue:" + minValue + " maxValue:" + maxValue);
        segment.setDateRangeStart(minValue);
        segment.setDateRangeEnd(maxValue);
    }
}

