/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.common.CubeStatsWriter;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeStatisticsStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(MergeStatisticsStep.class);
    protected Map<Long, HLLCounter> cuboidHLLMap = Maps.newHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        CubeManager mgr = CubeManager.getInstance((KylinConfig)context.getConfig());
        CubeInstance cube = mgr.getCube(CubingExecutableUtil.getCubeName(this.getParams()));
        CubeSegment newSegment = cube.getSegmentById(CubingExecutableUtil.getSegmentId(this.getParams()));
        KylinConfig kylinConf = cube.getConfig();
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        ResourceStore rs = ResourceStore.getStore((KylinConfig)kylinConf);
        try {
            int averageSamplingPercentage = 0;
            for (String segmentId : CubingExecutableUtil.getMergingSegmentIds(this.getParams())) {
                String fileKey = CubeSegment.getStatisticsResourcePath((String)CubingExecutableUtil.getCubeName(this.getParams()), (String)segmentId);
                InputStream is = rs.getResource((String)fileKey).inputStream;
                File tempFile = null;
                FileOutputStream tempFileStream = null;
                try {
                    tempFile = File.createTempFile(segmentId, ".seq");
                    tempFileStream = new FileOutputStream(tempFile);
                    IOUtils.copy((InputStream)is, (OutputStream)tempFileStream);
                }
                catch (Throwable throwable) {
                    org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
                    org.apache.hadoop.io.IOUtils.closeStream(tempFileStream);
                    throw throwable;
                }
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)tempFileStream);
                FileSystem fs = HadoopUtil.getFileSystem((String)("file:///" + tempFile.getAbsolutePath()));
                SequenceFile.Reader reader = null;
                try {
                    reader = new SequenceFile.Reader(fs, new Path(tempFile.getAbsolutePath()), conf);
                    LongWritable key = (LongWritable)ReflectionUtils.newInstance((Class)reader.getKeyClass(), (Configuration)conf);
                    BytesWritable value = (BytesWritable)ReflectionUtils.newInstance((Class)reader.getValueClass(), (Configuration)conf);
                    while (reader.next((Writable)key, (Writable)value)) {
                        if (key.get() == 0L) {
                            averageSamplingPercentage += Bytes.toInt((byte[])value.getBytes());
                            continue;
                        }
                        if (key.get() <= 0L) continue;
                        HLLCounter hll = new HLLCounter(kylinConf.getCubeStatsHLLPrecision());
                        ByteArray byteArray = new ByteArray(value.getBytes());
                        hll.readRegisters(byteArray.asBuffer());
                        if (this.cuboidHLLMap.get(key.get()) != null) {
                            this.cuboidHLLMap.get(key.get()).merge(hll);
                            continue;
                        }
                        this.cuboidHLLMap.put(key.get(), hll);
                    }
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        throw e;
                    }
                    catch (Throwable throwable) {
                        org.apache.hadoop.io.IOUtils.closeStream(reader);
                        if (tempFile != null) {
                            tempFile.delete();
                        }
                        throw throwable;
                    }
                }
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)reader);
                if (tempFile == null) continue;
                tempFile.delete();
            }
            CubeStatsWriter.writeCuboidStatistics(conf, new Path(CubingExecutableUtil.getMergedStatisticsPath(this.getParams())), this.cuboidHLLMap, averageSamplingPercentage /= CubingExecutableUtil.getMergingSegmentIds(this.getParams()).size());
            Path statisticsFilePath = new Path(CubingExecutableUtil.getMergedStatisticsPath(this.getParams()), "cuboid_statistics.seq");
            FileSystem fs = HadoopUtil.getFileSystem((Path)statisticsFilePath, (Configuration)conf);
            FSDataInputStream is = fs.open(statisticsFilePath);
            try {
                String statisticsFileName = newSegment.getStatisticsResourcePath();
                rs.putResource(statisticsFileName, (InputStream)is, System.currentTimeMillis());
            }
            finally {
                org.apache.hadoop.io.IOUtils.closeStream((Closeable)is);
            }
            return new ExecuteResult(ExecuteResult.State.SUCCEED, "succeed");
        }
        catch (IOException e) {
            logger.error("fail to merge cuboid statistics", (Throwable)e);
            return new ExecuteResult(ExecuteResult.State.ERROR, e.getLocalizedMessage());
        }
    }
}

