/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.steps;

import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.engine.mr.steps.FactDistinctColumnsMapperBase;
import org.apache.kylin.engine.mr.steps.SelfDefineSortableKey;
import org.apache.kylin.measure.hllc.HLLCounter;
import org.apache.kylin.measure.hllc.RegisterType;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactDistinctColumnsMapper<KEYIN>
extends FactDistinctColumnsMapperBase<KEYIN, Object> {
    private static final Logger logger = LoggerFactory.getLogger(FactDistinctColumnsMapper.class);
    protected boolean collectStatistics = false;
    protected CuboidScheduler cuboidScheduler = null;
    protected int nRowKey;
    private Integer[][] allCuboidsBitSet = null;
    private HLLCounter[] allCuboidsHLL = null;
    private Long[] cuboidIds;
    private HashFunction hf = null;
    private int rowCount = 0;
    private int samplingPercentage;
    private long[] rowHashCodesLong = null;
    private ByteArray[] row_hashcodes = null;
    private ByteBuffer tmpbuf;
    private static final Text EMPTY_TEXT = new Text();
    public static final byte MARK_FOR_PARTITION_COL = -2;
    public static final byte MARK_FOR_HLL = -1;
    private int partitionColumnIndex = -1;
    private boolean needFetchPartitionCol = true;
    private SelfDefineSortableKey sortableKey = new SelfDefineSortableKey();
    private boolean isUsePutRowKeyToHllNewAlgorithm;

    @Override
    protected void setup(Mapper.Context context) throws IOException {
        super.setup(context);
        this.tmpbuf = ByteBuffer.allocate(4096);
        this.collectStatistics = Boolean.parseBoolean(context.getConfiguration().get("statistics.enabled"));
        if (this.collectStatistics) {
            this.samplingPercentage = Integer.parseInt(context.getConfiguration().get("statistics.sampling.percent"));
            this.cuboidScheduler = new CuboidScheduler(this.cubeDesc);
            this.nRowKey = this.cubeDesc.getRowkey().getRowKeyColumns().length;
            ArrayList cuboidIdList = Lists.newArrayList();
            ArrayList allCuboidsBitSetList = Lists.newArrayList();
            this.addCuboidBitSet(this.baseCuboidId, allCuboidsBitSetList, cuboidIdList);
            this.allCuboidsBitSet = (Integer[][])allCuboidsBitSetList.toArray((T[])new Integer[cuboidIdList.size()][]);
            this.cuboidIds = cuboidIdList.toArray(new Long[cuboidIdList.size()]);
            this.allCuboidsHLL = new HLLCounter[this.cuboidIds.length];
            for (int i = 0; i < this.cuboidIds.length; ++i) {
                this.allCuboidsHLL[i] = new HLLCounter(this.cubeDesc.getConfig().getCubeStatsHLLPrecision(), RegisterType.DENSE);
            }
            TblColRef partitionColRef = this.cubeDesc.getModel().getPartitionDesc().getPartitionDateColumnRef();
            if (partitionColRef != null) {
                this.partitionColumnIndex = this.intermediateTableDesc.getColumnIndex(partitionColRef);
            }
            this.needFetchPartitionCol = this.partitionColumnIndex >= 0;
            if (KylinVersion.isBefore200((String)this.cubeDesc.getVersion())) {
                this.isUsePutRowKeyToHllNewAlgorithm = false;
                this.row_hashcodes = new ByteArray[this.nRowKey];
                for (int i = 0; i < this.nRowKey; ++i) {
                    this.row_hashcodes[i] = new ByteArray();
                }
                this.hf = Hashing.murmur3_32();
                logger.info("Found KylinVersion : {}. Use old algorithm for cuboid sampling.", (Object)this.cubeDesc.getVersion());
            } else {
                this.isUsePutRowKeyToHllNewAlgorithm = true;
                this.rowHashCodesLong = new long[this.nRowKey];
                this.hf = Hashing.murmur3_128();
                logger.info("Found KylinVersion : {}. Use new algorithm for cuboid sampling. About the details of the new algorithm, please refer to KYLIN-2518", (Object)this.cubeDesc.getVersion());
            }
        }
    }

    private void addCuboidBitSet(long cuboidId, List<Integer[]> allCuboidsBitSet, List<Long> allCuboids) {
        allCuboids.add(cuboidId);
        Integer[] indice = new Integer[Long.bitCount(cuboidId)];
        long mask = Long.highestOneBit(this.baseCuboidId);
        int position = 0;
        for (int i = 0; i < this.nRowKey; ++i) {
            if ((mask & cuboidId) > 0L) {
                indice[position] = i;
                ++position;
            }
            mask >>= 1;
        }
        allCuboidsBitSet.add(indice);
        List children = this.cuboidScheduler.getSpanningCuboid(cuboidId);
        for (Long childId : children) {
            this.addCuboidBitSet(childId, allCuboidsBitSet, allCuboids);
        }
    }

    @Override
    public void doMap(KEYIN key, Object record, Mapper.Context context) throws IOException, InterruptedException {
        String[] row = this.flatTableInputFormat.parseMapperInput(record);
        context.getCounter((Enum)RawDataCounter.BYTES).increment(this.countSizeInBytes(row));
        for (int i = 0; i < this.factDictCols.size(); ++i) {
            String fieldValue = row[this.dictionaryColumnIndex[i]];
            if (fieldValue == null) continue;
            int reducerIndex = this.uhcIndex[i] == 0 ? (Integer)this.columnIndexToReducerBeginId.get(i) : (Integer)this.columnIndexToReducerBeginId.get(i) + (fieldValue.hashCode() & Integer.MAX_VALUE) % this.uhcReducerCount;
            this.tmpbuf.clear();
            byte[] valueBytes = Bytes.toBytes((String)fieldValue);
            int size = valueBytes.length + 1;
            if (size >= this.tmpbuf.capacity()) {
                this.tmpbuf = ByteBuffer.allocate(this.countNewSize(this.tmpbuf.capacity(), size));
            }
            this.tmpbuf.put(Bytes.toBytes((int)reducerIndex)[3]);
            this.tmpbuf.put(valueBytes);
            this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
            DataType type = ((TblColRef)this.factDictCols.get(i)).getType();
            this.sortableKey.init(this.outputKey, type);
            context.write((Object)this.sortableKey, (Object)EMPTY_TEXT);
            if (this.rowCount >= 10) continue;
            logger.info("Sample output: " + this.factDictCols.get(i) + " '" + fieldValue + "' => reducer " + reducerIndex);
        }
        if (this.collectStatistics) {
            String fieldValue;
            if (this.rowCount % 100 < this.samplingPercentage) {
                if (this.isUsePutRowKeyToHllNewAlgorithm) {
                    this.putRowKeyToHLLNew(row);
                } else {
                    this.putRowKeyToHLLOld(row);
                }
            }
            if (this.needFetchPartitionCol && (fieldValue = row[this.partitionColumnIndex]) != null) {
                this.tmpbuf.clear();
                byte[] valueBytes = Bytes.toBytes((String)fieldValue);
                int size = valueBytes.length + 1;
                if (size >= this.tmpbuf.capacity()) {
                    this.tmpbuf = ByteBuffer.allocate(this.countNewSize(this.tmpbuf.capacity(), size));
                }
                this.tmpbuf.put((byte)-2);
                this.tmpbuf.put(valueBytes);
                this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
                this.sortableKey.init(this.outputKey, (byte)0);
                context.write((Object)this.sortableKey, (Object)EMPTY_TEXT);
            }
        }
        ++this.rowCount;
    }

    private long countSizeInBytes(String[] row) {
        int size = 0;
        for (String s : row) {
            size += s == null ? 1 : StringUtil.utf8Length((CharSequence)s);
            ++size;
        }
        return size;
    }

    private void putRowKeyToHLLOld(String[] row) {
        int i;
        for (i = 0; i < this.nRowKey; ++i) {
            Hasher hc = this.hf.newHasher();
            String colValue = row[this.intermediateTableDesc.getRowKeyColumnIndexes()[i]];
            if (colValue != null) {
                this.row_hashcodes[i].set(hc.putString((CharSequence)colValue).hash().asBytes());
                continue;
            }
            this.row_hashcodes[i].set(hc.putInt(0).hash().asBytes());
        }
        int n = this.allCuboidsBitSet.length;
        for (i = 0; i < n; ++i) {
            Hasher hc = this.hf.newHasher();
            for (int position = 0; position < this.allCuboidsBitSet[i].length; ++position) {
                hc.putBytes(this.row_hashcodes[this.allCuboidsBitSet[i][position]].array());
            }
            this.allCuboidsHLL[i].add(hc.hash().asBytes());
        }
    }

    private void putRowKeyToHLLNew(String[] row) {
        int i;
        for (i = 0; i < this.nRowKey; ++i) {
            Hasher hc = this.hf.newHasher();
            String colValue = row[this.intermediateTableDesc.getRowKeyColumnIndexes()[i]];
            if (colValue == null) {
                colValue = "0";
            }
            byte[] bytes = hc.putString((CharSequence)colValue).hash().asBytes();
            this.rowHashCodesLong[i] = Bytes.toLong((byte[])bytes) + (long)i;
        }
        int n = this.allCuboidsBitSet.length;
        for (i = 0; i < n; ++i) {
            long value = 0L;
            for (int position = 0; position < this.allCuboidsBitSet[i].length; ++position) {
                value += this.rowHashCodesLong[this.allCuboidsBitSet[i][position]];
            }
            this.allCuboidsHLL[i].addHashDirectly(value);
        }
    }

    @Override
    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.collectStatistics) {
            ByteBuffer hllBuf = ByteBuffer.allocate(0x100000);
            for (int i = 0; i < this.cuboidIds.length; ++i) {
                HLLCounter hll = this.allCuboidsHLL[i];
                this.tmpbuf.clear();
                this.tmpbuf.put((byte)-1);
                this.tmpbuf.putLong(this.cuboidIds[i]);
                this.outputKey.set(this.tmpbuf.array(), 0, this.tmpbuf.position());
                hllBuf.clear();
                hll.writeRegisters(hllBuf);
                this.outputValue.set(hllBuf.array(), 0, hllBuf.position());
                this.sortableKey.init(this.outputKey, (byte)0);
                context.write((Object)this.sortableKey, (Object)this.outputValue);
            }
        }
    }

    private int countNewSize(int oldSize, int dataSize) {
        int newSize;
        for (newSize = oldSize * 2; newSize < dataSize; newSize *= 2) {
        }
        return newSize;
    }

    public static enum RawDataCounter {
        BYTES;

    }
}

