/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.CubeUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidShardUtil {
    protected static final Logger logger = LoggerFactory.getLogger(CuboidShardUtil.class);

    public static void saveCuboidShards(CubeSegment segment, Map<Long, Short> cuboidShards, int totalShards) throws IOException {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)segment.getConfig());
        HashMap filtered = Maps.newHashMap();
        for (Map.Entry<Long, Short> entry : cuboidShards.entrySet()) {
            if (entry.getValue() <= 1) {
                logger.info("Cuboid {} has {} shards, skip saving it as an optimization", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            logger.info("Cuboid {} has {} shards, saving it", (Object)entry.getKey(), (Object)entry.getValue());
            filtered.put(entry.getKey(), entry.getValue());
        }
        segment.setCuboidShardNums((Map)filtered);
        segment.setTotalShards(totalShards);
        CubeUpdate cubeBuilder = new CubeUpdate(segment.getCubeInstance());
        cubeBuilder.setToUpdateSegs(new CubeSegment[]{segment});
        cubeManager.updateCube(cubeBuilder);
    }
}

