/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.dict.ByteComparator;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.engine.mr.DFSFileTable;
import org.apache.kylin.engine.mr.DFSFileTableReader;
import org.apache.kylin.engine.mr.SortedColumnDFSFileReader;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.source.ReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedColumnDFSFile
implements ReadableTable {
    private static final Logger logger = LoggerFactory.getLogger(SortedColumnDFSFile.class);
    private String dfsPath;
    private DFSFileTable dfsFileTable;
    private DataType dataType;

    public SortedColumnDFSFile(String path, DataType dataType) {
        this.dfsPath = path;
        this.dfsFileTable = new DFSFileTable(path, -1);
        this.dataType = dataType;
    }

    public ReadableTable.TableReader getReader() throws IOException {
        Comparator<String> comparator = this.getComparatorByType(this.dataType);
        ArrayList<ReadableTable.TableReader> readers = new ArrayList<ReadableTable.TableReader>();
        String filePath = HadoopUtil.fixWindowsPath((String)this.dfsPath);
        FileSystem fs = HadoopUtil.getFileSystem((String)filePath);
        ArrayList<FileStatus> allFiles = new ArrayList<FileStatus>();
        FileStatus status = fs.getFileStatus(new Path(filePath));
        if (status.isFile()) {
            allFiles.add(status);
        } else {
            FileStatus[] listStatus;
            for (FileStatus f : listStatus = fs.listStatus(new Path(filePath))) {
                if (!f.isFile()) continue;
                allFiles.add(f);
            }
        }
        for (FileStatus f : allFiles) {
            DFSFileTableReader reader = new DFSFileTableReader(f.getPath().toString(), -1);
            readers.add(reader);
        }
        return new SortedColumnDFSFileReader(readers, comparator);
    }

    public ReadableTable.TableSignature getSignature() throws IOException {
        return this.dfsFileTable.getSignature();
    }

    public boolean exists() throws IOException {
        return this.dfsFileTable.exists();
    }

    private Comparator<String> getComparatorByType(DataType type) {
        Object comparator = !type.isNumberFamily() ? new ByteComparator((BytesConverter)new StringBytesConverter()) : (type.isIntegerFamily() ? new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                try {
                    Long num1 = Long.parseLong(str1);
                    Long num2 = Long.parseLong(str2);
                    return num1.compareTo(num2);
                }
                catch (NumberFormatException e) {
                    logger.error("NumberFormatException when parse integer family number.str1:" + str1 + " str2:" + str2);
                    e.printStackTrace();
                    return 0;
                }
            }
        } : new Comparator<String>(){

            @Override
            public int compare(String str1, String str2) {
                try {
                    Double num1 = Double.parseDouble(str1);
                    Double num2 = Double.parseDouble(str2);
                    return num1.compareTo(num2);
                }
                catch (NumberFormatException e) {
                    logger.error("NumberFormatException when parse doul family number.str1:" + str1 + " str2:" + str2);
                    return 0;
                }
            }
        });
        return comparator;
    }

    public String toString() {
        return this.dfsPath;
    }
}

