/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinReducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private static final Logger logger = LoggerFactory.getLogger(KylinReducer.class);
    protected int reduceCounter = 0;

    protected void bindCurrentConfiguration(Configuration conf) {
        HadoopUtil.setCurrentConfiguration((Configuration)conf);
    }

    public final void reduce(KEYIN key, Iterable<VALUEIN> values, Reducer.Context context) throws IOException, InterruptedException {
        try {
            if (this.reduceCounter++ % 100000 == 0) {
                logger.info("Accepting Reducer Key with ordinal: " + this.reduceCounter);
            }
            this.doReduce(key, values, context);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
    }

    protected void doReduce(KEYIN key, Iterable<VALUEIN> values, Reducer.Context context) throws IOException, InterruptedException {
        super.reduce(key, values, context);
    }

    protected final void cleanup(Reducer.Context context) throws IOException, InterruptedException {
        try {
            this.doCleanup(context);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
    }

    protected void doCleanup(Reducer.Context context) throws IOException, InterruptedException {
    }
}

