/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.common.util.HadoopUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KylinMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private static final Logger logger = LoggerFactory.getLogger(KylinMapper.class);
    protected int mapCounter = 0;

    protected void bindCurrentConfiguration(Configuration conf) {
        logger.info("The conf for current mapper will be " + System.identityHashCode(conf));
        HadoopUtil.setCurrentConfiguration((Configuration)conf);
    }

    public final void map(KEYIN key, VALUEIN value, Mapper.Context context) throws IOException, InterruptedException {
        try {
            if (this.mapCounter++ % 100000 == 0) {
                logger.info("Accepting Mapper Key with ordinal: " + this.mapCounter);
            }
            this.doMap(key, value, context);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
    }

    protected void doMap(KEYIN key, VALUEIN value, Mapper.Context context) throws IOException, InterruptedException {
        super.map(key, value, context);
    }

    protected final void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        try {
            this.doCleanup(context);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (InterruptedException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
        catch (Error ex) {
            logger.error("", (Throwable)ex);
            throw ex;
        }
    }

    protected void doCleanup(Mapper.Context context) throws IOException, InterruptedException {
    }
}

