/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.steps.CubingExecutableUtil;
import org.apache.kylin.engine.mr.steps.MergeStatisticsStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMergeJobBuilder2
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchMergeJobBuilder2.class);
    private final IMROutput2.IMRBatchMergeOutputSide2 outputSide;
    private final IMRInput.IMRBatchMergeInputSide inputSide;

    public BatchMergeJobBuilder2(CubeSegment mergeSegment, String submitter) {
        super(mergeSegment, submitter);
        this.outputSide = MRUtil.getBatchMergeOutputSide2(this.seg);
        this.inputSide = MRUtil.getBatchMergeInputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V2 new job to MERGE segment " + this.seg);
        CubeSegment cubeSegment = this.seg;
        CubingJob result = CubingJob.createMergeJob(cubeSegment, this.submitter, this.config);
        String jobId = result.getId();
        List mergingSegments = cubeSegment.getCubeInstance().getMergingSegments(cubeSegment);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)("there should be more than 2 segments to merge, target segment " + cubeSegment));
        ArrayList mergingSegmentIds = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingSegmentIds.add(merging.getUuid());
        }
        this.inputSide.addStepPhase1_MergeDictionary(result);
        result.addTask(this.createMergeDictionaryStep(mergingSegmentIds));
        result.addTask(this.createMergeStatisticsStep(cubeSegment, mergingSegmentIds, this.getStatisticsPath(jobId)));
        this.outputSide.addStepPhase1_MergeDictionary(result);
        this.outputSide.addStepPhase2_BuildCube(this.seg, mergingSegments, result);
        result.addTask(this.createUpdateCubeInfoAfterMergeStep(mergingSegmentIds, jobId));
        this.outputSide.addStepPhase3_Cleanup(result);
        return result;
    }

    private MergeStatisticsStep createMergeStatisticsStep(CubeSegment seg, List<String> mergingSegmentIds, String mergedStatisticsFolder) {
        MergeStatisticsStep result = new MergeStatisticsStep();
        result.setName("Merge Cuboid Statistics");
        CubingExecutableUtil.setCubeName(seg.getRealization().getName(), result.getParams());
        CubingExecutableUtil.setSegmentId(seg.getUuid(), result.getParams());
        CubingExecutableUtil.setMergingSegmentIds(mergingSegmentIds, result.getParams());
        CubingExecutableUtil.setMergedStatisticsPath(mergedStatisticsFolder, result.getParams());
        return result;
    }
}

