/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr;

import com.google.common.base.Preconditions;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.engine.mr.CubingJob;
import org.apache.kylin.engine.mr.IMRInput;
import org.apache.kylin.engine.mr.IMROutput;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.engine.mr.steps.BaseCuboidJob;
import org.apache.kylin.engine.mr.steps.NDCuboidJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchCubingJobBuilder
extends JobBuilderSupport {
    private static final Logger logger = LoggerFactory.getLogger(BatchCubingJobBuilder.class);
    private final IMRInput.IMRBatchCubingInputSide inputSide;
    private final IMROutput.IMRBatchCubingOutputSide outputSide;

    public BatchCubingJobBuilder(CubeSegment newSegment, String submitter) {
        super(newSegment, submitter);
        Preconditions.checkArgument((!newSegment.isEnableSharding() ? 1 : 0) != 0, (Object)"V1 job engine does not support building sharded cubes");
        this.inputSide = MRUtil.getBatchCubingInputSide(this.seg);
        this.outputSide = MRUtil.getBatchCubingOutputSide(this.seg);
    }

    public CubingJob build() {
        logger.info("MR_V1 new job to BUILD segment " + this.seg);
        CubingJob result = CubingJob.createBuildJob(this.seg, this.submitter, this.config);
        String jobId = result.getId();
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        this.inputSide.addStepPhase1_CreateFlatTable(result);
        result.addTask(this.createFactDistinctColumnsStep(jobId));
        result.addTask(this.createBuildDictionaryStep(jobId));
        RowKeyDesc rowKeyDesc = this.seg.getCubeDesc().getRowkey();
        int groupRowkeyColumnsCount = this.seg.getCubeDesc().getBuildLevel();
        result.addTask(this.createBaseCuboidStep(BatchCubingJobBuilder.getCuboidOutputPathsByLevel(cuboidRootPath, 0), jobId));
        for (int i = 1; i <= groupRowkeyColumnsCount; ++i) {
            result.addTask(this.createNDimensionCuboidStep(BatchCubingJobBuilder.getCuboidOutputPathsByLevel(cuboidRootPath, i - 1), BatchCubingJobBuilder.getCuboidOutputPathsByLevel(cuboidRootPath, i), i));
        }
        this.outputSide.addStepPhase3_BuildCube(result, cuboidRootPath);
        result.addTask(this.createUpdateCubeInfoAfterBuildStep(jobId));
        this.inputSide.addStepPhase4_Cleanup(result);
        this.outputSide.addStepPhase4_Cleanup(result);
        return result;
    }

    private MapReduceExecutable createBaseCuboidStep(String cuboidOutputPath, String jobId) {
        MapReduceExecutable baseCuboidStep = new MapReduceExecutable();
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        baseCuboidStep.setName("Build Base Cuboid");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "input", "FLAT_TABLE");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "output", cuboidOutputPath);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "jobname", "Kylin_Base_Cuboid_Builder_" + this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "level", "0");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "cubingJobId", jobId);
        baseCuboidStep.setMapReduceParams(cmd.toString());
        baseCuboidStep.setMapReduceJobClass(BaseCuboidJob.class);
        return baseCuboidStep;
    }

    private MapReduceExecutable createNDimensionCuboidStep(String parentPath, String outputPath, int level) {
        MapReduceExecutable ndCuboidStep = new MapReduceExecutable();
        ndCuboidStep.setName("Build N-Dimension Cuboid : level " + level);
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "cubename", this.seg.getRealization().getName());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "segmentid", this.seg.getUuid());
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "input", parentPath);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "output", outputPath);
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "jobname", "Kylin_ND-Cuboid_Builder_" + this.seg.getRealization().getName() + "_Step");
        BatchCubingJobBuilder.appendExecCmdParameters(cmd, "level", "" + level);
        ndCuboidStep.setMapReduceParams(cmd.toString());
        ndCuboidStep.setMapReduceJobClass(NDCuboidJob.class);
        return ndCuboidStep;
    }
}

