/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.table.ATable;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.S3TableExtInfo;
import org.apache.kylin.rest.request.TableExclusionRequest;
import org.apache.kylin.rest.request.TableLoadRequest;
import org.apache.kylin.rest.request.UpdateAWSTableExtDescRequest;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.ExcludedColumnResponse;
import org.apache.kylin.rest.response.ExcludedTableDetailResponse;
import org.apache.kylin.rest.response.ExcludedTableResponse;
import org.apache.kylin.rest.response.LoadTableResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.response.UpdateAWSTableExtDescResponse;
import org.apache.kylin.rest.security.KerberosLoginManager;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.InternalTableService;
import org.apache.kylin.rest.service.ProjectService;
import org.apache.kylin.rest.service.TableService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.kylin.source.SourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="tableExtService")
public class TableExtService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(TableExtService.class);
    public static final int DEFAULT_EXCLUDED_COLUMN_SIZE = 15;
    public static final int ONCE_LOAD_TABLE_LIMIT_COUNT = 1000;
    @Autowired
    @Qualifier(value="tableService")
    private TableService tableService;
    @Autowired
    private InternalTableService internalTableService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    private ProjectService projectService;

    public LoadTableResponse loadTablesWithShortCircuit(TableLoadRequest request) throws Exception {
        String project = request.getProject();
        this.aclEvaluate.checkProjectWritePermission(project);
        HashSet existDbs = Sets.newHashSet(this.tableService.getSourceDbNames(project));
        int count = 0;
        int dbSize = ArrayUtils.isNotEmpty((Object[])request.getDatabases()) ? request.getDatabases().length : 0;
        int tableSize = ArrayUtils.isNotEmpty((Object[])request.getTables()) ? request.getTables().length : 0;
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        boolean thresholdEnabled = kylinConfig.isTableLoadThresholdEnabled();
        this.checkThreshold(thresholdEnabled, tableSize);
        LoadTableResponse tableResponseFromDB = null;
        List canLoadTablesFromDB = null;
        HashMap<String, Set<String>> dbs = new HashMap();
        if (dbSize > 0) {
            tableResponseFromDB = new LoadTableResponse();
            StringHelper.toUpperCaseArray((String[])request.getDatabases(), (String[])request.getDatabases());
            dbs = this.classifyDbTables(request.getDatabases(), true);
            Pair<List<Pair<TableDesc, TableExtDesc>>, Integer> pair = this.findCanLoadTables(dbs, project, true, tableResponseFromDB, existDbs, Maps.newHashMap());
            canLoadTablesFromDB = (List)pair.getFirst();
            count = (Integer)pair.getSecond();
            this.checkThreshold(thresholdEnabled, count);
        }
        LoadTableResponse tableResponse = null;
        List canLoadTables = null;
        if (tableSize > 0) {
            StringHelper.toUpperCaseArray((String[])request.getTables(), (String[])request.getTables());
            Map<String, Set<String>> tables = this.classifyDbTables(request.getTables(), false);
            tableResponse = new LoadTableResponse();
            Pair<List<Pair<TableDesc, TableExtDesc>>, Integer> pair = this.findCanLoadTables(tables, project, false, tableResponse, existDbs, dbs);
            canLoadTables = (List)pair.getFirst();
            count = (Integer)pair.getSecond() + count;
            this.checkThreshold(thresholdEnabled, count);
        }
        LoadTableResponse loadTableResponse = new LoadTableResponse();
        if (tableResponseFromDB != null) {
            if (!canLoadTablesFromDB.isEmpty()) {
                this.innerLoadTables(project, tableResponseFromDB, canLoadTablesFromDB, request.getLoadAsInternal(), request.getStorageType());
            }
            loadTableResponse.getFailed().addAll(tableResponseFromDB.getFailed());
            loadTableResponse.getLoaded().addAll(tableResponseFromDB.getLoaded());
            loadTableResponse.getNeedRealSampling().addAll(tableResponseFromDB.getNeedRealSampling());
        }
        if (tableResponse != null) {
            if (!canLoadTables.isEmpty()) {
                this.innerLoadTables(project, tableResponse, canLoadTables, request.getLoadAsInternal(), request.getStorageType());
            }
            loadTableResponse.getFailed().addAll(tableResponse.getFailed());
            loadTableResponse.getLoaded().addAll(tableResponse.getLoaded());
            loadTableResponse.getNeedRealSampling().addAll(tableResponse.getNeedRealSampling());
        }
        return loadTableResponse;
    }

    private void checkThreshold(boolean thresholdEnabled, int count) {
        if (thresholdEnabled && count > 1000) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.ONCE_LOAD_TABLE_LIMIT, new Object[0]);
        }
    }

    public Pair<List<Pair<TableDesc, TableExtDesc>>, Integer> findCanLoadTables(Map<String, Set<String>> dbTables, String project, boolean isDb, LoadTableResponse tableResponse, Set<String> existDbs, Map<String, Set<String>> formalDbs) throws Exception {
        ArrayList canLoadTables = Lists.newArrayList();
        ArrayList responseAll = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : dbTables.entrySet()) {
            String[] tables;
            String db = entry.getKey();
            Set<String> tableSet = entry.getValue();
            if (!existDbs.contains(db)) {
                if (isDb) {
                    tableResponse.getFailed().add(db);
                    continue;
                }
                List tables2 = tableSet.stream().map(table -> db + "." + table).collect(Collectors.toList());
                tableResponse.getFailed().addAll(tables2);
                continue;
            }
            HashSet existTables = Sets.newHashSet(this.tableService.getSourceTableNames(project, db, ""));
            HashSet failTables = Sets.newHashSet(tableSet);
            if (!isDb) {
                existTables.retainAll(tableSet);
                failTables.removeAll(existTables);
                tables = failTables.stream().map(table -> db + "." + table).collect(Collectors.toList());
                tableResponse.getFailed().addAll(tables);
            }
            if (formalDbs.size() != 0 && formalDbs.get(db) != null) continue;
            tables = (String[])existTables.stream().map(table -> db + "." + table).toArray(String[]::new);
            if (tables.length > 0) {
                this.filterAccessTables(tables, canLoadTables, tableResponse, project);
            }
            List<TableNameResponse> response = this.tableService.getHiveTableNameResponses(project, db, "");
            response.forEach(t -> t.setTableName(db + "." + t.getTableName()));
            responseAll.addAll(response);
        }
        return new Pair((Object)canLoadTables, (Object)this.getTableCount(responseAll, canLoadTables));
    }

    private int getTableCount(List<TableNameResponse> responseAll, List<Pair<TableDesc, TableExtDesc>> canLoadTables) {
        List loaded = responseAll.stream().filter(TableNameResponse::isLoaded).map(TableNameResponse::getTableName).collect(Collectors.toList());
        return (int)canLoadTables.stream().filter(t -> !loaded.contains(((TableDesc)t.getFirst()).getIdentity())).count();
    }

    public LoadTableResponse loadDbTables(String[] dbTables, String project, boolean isDb) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        HashSet existDbs = Sets.newHashSet(this.tableService.getSourceDbNames(project));
        LoadTableResponse tableResponse = new LoadTableResponse();
        Map<String, Set<String>> tables = this.classifyDbTables(dbTables, isDb);
        List canLoadTables = (List)this.findCanLoadTables(tables, project, isDb, tableResponse, existDbs, Maps.newHashMap()).getFirst();
        if (!canLoadTables.isEmpty()) {
            return this.innerLoadTables(project, tableResponse, canLoadTables, false, null);
        }
        return tableResponse;
    }

    @VisibleForTesting
    public void filterAccessTables(String[] tables, List<Pair<TableDesc, TableExtDesc>> canLoadTables, LoadTableResponse tableResponse, String project) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        List<Pair<TableDesc, TableExtDesc>> toLoadTables = this.extractTableMeta(tables, project, tableResponse);
        if (!config.isDDLLogicalViewEnabled()) {
            canLoadTables.addAll(toLoadTables);
            return;
        }
        String viewDB = config.getDDLLogicalViewDB();
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)config);
        toLoadTables.stream().filter(table -> !((TableDesc)table.getFirst()).isLogicalView()).forEach(canLoadTables::add);
        toLoadTables.stream().filter(table -> ((TableDesc)table.getFirst()).isLogicalView()).forEach(table -> {
            String viewProject;
            String tableName = ((TableDesc)table.getFirst()).getName();
            LogicalView logicalTable = viewManager.get(tableName);
            String string = viewProject = logicalTable != null ? logicalTable.getCreatedProject() : "unknown";
            if (logicalTable != null && viewProject.equalsIgnoreCase(project)) {
                canLoadTables.add((Pair<TableDesc, TableExtDesc>)table);
            } else {
                tableResponse.getFailed().add(viewDB + "." + tableName);
            }
        });
    }

    public LoadTableResponse loadAWSTablesCompatibleCrossAccount(List<S3TableExtInfo> s3TableExtInfoList, String project) throws Exception {
        this.aclEvaluate.checkProjectWritePermission(project);
        ArrayList<String> dbTableList = new ArrayList<String>();
        HashMap<String, S3TableExtInfo> map = new HashMap<String, S3TableExtInfo>();
        for (S3TableExtInfo s3TableExtInfo : s3TableExtInfoList) {
            dbTableList.add(s3TableExtInfo.getName());
            map.put(s3TableExtInfo.getName(), s3TableExtInfo);
        }
        String[] dbTables = dbTableList.toArray(new String[0]);
        Map<String, Set<String>> dbTableMap = this.classifyDbTables(dbTables, false);
        HashSet existDbs = Sets.newHashSet(this.tableService.getSourceDbNames(project));
        LoadTableResponse tableResponse = new LoadTableResponse();
        ArrayList loadTables = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : dbTableMap.entrySet()) {
            String db = entry.getKey();
            Set<String> tableSet = entry.getValue();
            if (!existDbs.contains(db)) {
                List tables = tableSet.stream().map(table -> db + "." + table).collect(Collectors.toList());
                tableResponse.getFailed().addAll(tables);
                continue;
            }
            HashSet existTables = Sets.newHashSet(this.tableService.getSourceTableNames(project, db, ""));
            HashSet failTables = Sets.newHashSet(tableSet);
            existTables.retainAll(tableSet);
            failTables.removeAll(existTables);
            List tmpTables = failTables.stream().map(table -> db + "." + table).collect(Collectors.toList());
            tableResponse.getFailed().addAll(tmpTables);
            String[] tables = (String[])existTables.stream().map(table -> db + "." + table).toArray(String[]::new);
            if (tables.length <= 0) continue;
            List<Pair<TableDesc, TableExtDesc>> tableDescs = this.extractTableMeta(tables, project, tableResponse);
            for (Pair<TableDesc, TableExtDesc> tableExtDescPair : tableDescs) {
                TableDesc tableDesc = (TableDesc)tableExtDescPair.getFirst();
                TableExtDesc tableExtDesc = (TableExtDesc)tableExtDescPair.getSecond();
                String tableKey = tableDesc.getDatabase() + "." + tableDesc.getName();
                S3TableExtInfo target = (S3TableExtInfo)map.get(tableKey);
                if (null != target) {
                    tableExtDesc.addDataSourceProp(TableExtDesc.S3_ROLE_PROPERTY_KEY, target.getRoleArn());
                    tableExtDesc.addDataSourceProp(TableExtDesc.S3_ENDPOINT_KEY, target.getEndpoint());
                    loadTables.add(tableExtDescPair);
                    continue;
                }
                tableResponse.getFailed().add(tableKey);
            }
        }
        if (!loadTables.isEmpty()) {
            return this.innerLoadTables(project, tableResponse, loadTables, false, null);
        }
        return tableResponse;
    }

    public UpdateAWSTableExtDescResponse updateAWSLoadedTableExtProp(UpdateAWSTableExtDescRequest request) {
        this.aclEvaluate.checkProjectOperationPermission(request.getProject());
        UpdateAWSTableExtDescResponse response = new UpdateAWSTableExtDescResponse();
        HashMap<String, S3TableExtInfo> map = new HashMap<String, S3TableExtInfo>();
        for (S3TableExtInfo s3TableExtInfo : request.getTables()) {
            map.put(s3TableExtInfo.getName(), s3TableExtInfo);
        }
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, request.getProject());
        List projectTableDescList = tableMetadataManager.listAllTables();
        List identityList = projectTableDescList.stream().map(ATable::getIdentity).filter(identity -> map.get(identity) != null).collect(Collectors.toList());
        return (UpdateAWSTableExtDescResponse)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NTableMetadataManager innerTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, request.getProject());
            HashSet<TableExtDesc.RoleCredentialInfo> broadcasttedConf = new HashSet<TableExtDesc.RoleCredentialInfo>();
            for (String identity : identityList) {
                TableDesc tableDesc = innerTableMetadataManager.getTableDesc(identity);
                TableExtDesc extDesc = innerTableMetadataManager.getTableExtIfExists(tableDesc);
                if (null == extDesc) {
                    response.getFailed().add(identity);
                    continue;
                }
                TableExtDesc copyExt = innerTableMetadataManager.copyForWrite(extDesc);
                S3TableExtInfo s3TableExtInfo = (S3TableExtInfo)map.get(identity);
                copyExt.addDataSourceProp(TableExtDesc.S3_ROLE_PROPERTY_KEY, s3TableExtInfo.getRoleArn());
                copyExt.addDataSourceProp(TableExtDesc.S3_ENDPOINT_KEY, s3TableExtInfo.getEndpoint());
                innerTableMetadataManager.saveTableExt(copyExt);
                if (!broadcasttedConf.contains(copyExt.getRoleCredentialInfo())) {
                    this.tableService.addAndBroadcastSparkSession(copyExt.getRoleCredentialInfo());
                    broadcasttedConf.add(copyExt.getRoleCredentialInfo());
                }
                response.getSucceed().add(identity);
            }
            return response;
        }, (String)request.getProject());
    }

    private LoadTableResponse innerLoadTables(String project, LoadTableResponse tableResponse, List<Pair<TableDesc, TableExtDesc>> loadTables, Boolean loadAsInternal, String storageType) {
        int batchSize = NProjectManager.getProjectConfig((String)project).getLoadTableBatchSize();
        List<List<Pair<TableDesc, TableExtDesc>>> batches = this.splitIntoBatches(loadTables, batchSize);
        if (loadAsInternal.booleanValue() && !KylinConfig.getInstanceFromEnv().queryUseGlutenEnabled()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.GLUTEN_NOT_ENABLED_ERROR, String.format(Locale.ROOT, MsgPicker.getMsg().getGlutenDisabled(), new Object[0]));
        }
        for (List<Pair<TableDesc, TableExtDesc>> batch : batches) {
            try {
                this.microBatchLoadTable(project, tableResponse, batch, loadAsInternal, storageType);
            }
            catch (Exception e) {
                logger.error("Load table transaction failure : ", (Throwable)e);
                tableResponse.getFailed().addAll(batch.stream().map(pair -> ((TableDesc)pair.getFirst()).getIdentity()).collect(Collectors.toSet()));
            }
        }
        return tableResponse;
    }

    private LoadTableResponse microBatchLoadTable(String project, LoadTableResponse tableResponse, List<Pair<TableDesc, TableExtDesc>> batch, Boolean loadAsInternal, String storageType) {
        return (LoadTableResponse)EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project);
            batch.forEach(pair -> {
                TableDesc tableDesc = (TableDesc)pair.getFirst();
                TableExtDesc tableExtDesc = (TableExtDesc)pair.getSecond();
                String tableName = tableDesc.getIdentity();
                boolean success = true;
                boolean realLoaded = false;
                if (tableManager.getTableDesc(tableName) == null) {
                    realLoaded = true;
                    try {
                        tableDesc.setProject(project);
                        this.loadTable(tableDesc, tableExtDesc, project);
                        if (loadAsInternal.booleanValue()) {
                            this.internalTableService.createInternalTable(project, tableDesc, storageType);
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Failed to load table ({}/{})", new Object[]{project, tableName, ex});
                        success = false;
                    }
                }
                Set targetSet = success ? tableResponse.getLoaded() : tableResponse.getFailed();
                targetSet.add(tableName);
                if (success && realLoaded) {
                    tableResponse.getNeedRealSampling().add(tableName);
                }
            });
            return tableResponse;
        }, (String)project, (int)2);
    }

    private List<List<Pair<TableDesc, TableExtDesc>>> splitIntoBatches(List<Pair<TableDesc, TableExtDesc>> loadTables, int batchSize) {
        ArrayList<List<Pair<TableDesc, TableExtDesc>>> batches = new ArrayList<List<Pair<TableDesc, TableExtDesc>>>();
        for (int i = 0; i < loadTables.size(); i += batchSize) {
            batches.add(new ArrayList<Pair<TableDesc, TableExtDesc>>(loadTables.subList(i, Math.min(i + batchSize, loadTables.size()))));
        }
        logger.info("Split all {} table into {} batches", (Object)loadTables.size(), (Object)batches.size());
        return batches;
    }

    private List<Pair<TableDesc, TableExtDesc>> extractTableMeta(String[] tables, String project, LoadTableResponse tableResponse) throws IOException, InterruptedException {
        UserGroupInformation ugi = KerberosLoginManager.getInstance().getProjectUGI(project);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return (List)ugi.doAs(() -> {
            ProjectInstance projectInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
            List<Pair<TableDesc, TableExtDesc>> extractTableMetas = this.tableService.extractTableMeta(tables, project, tableResponse);
            if (config.getTableAccessFilterEnable() && projectInstance.isProjectKerberosEnabled()) {
                return extractTableMetas.stream().map(pair -> {
                    TableDesc tableDesc = (TableDesc)pair.getFirst();
                    String tableName = tableDesc.getIdentity();
                    ISourceMetadataExplorer explr = SourceFactory.getSource((ISourceAware)projectInstance).getSourceMetadataExplorer();
                    if (!explr.checkTablesAccess((Set)Sets.newHashSet((Object[])new String[]{tableName}))) {
                        tableResponse.getFailed().add(tableName);
                        return null;
                    }
                    return pair;
                }).filter(Objects::nonNull).collect(Collectors.toList());
            }
            return extractTableMetas;
        });
    }

    private Map<String, Set<String>> classifyDbTables(String[] dbTables, boolean isDb) {
        HashMap dbTableMap = Maps.newHashMap();
        for (String str : dbTables) {
            String db;
            String table = null;
            if (isDb) {
                db = StringUtils.upperCase((String)str);
            } else {
                String[] dbTableName = HadoopUtil.parseHiveTableName((String)str);
                db = StringUtils.upperCase((String)dbTableName[0]);
                table = StringUtils.upperCase((String)dbTableName[1]);
            }
            Set tables = dbTableMap.getOrDefault(db, Sets.newHashSet());
            if (table != null) {
                tables.add(table);
            }
            dbTableMap.put(db, tables);
        }
        return dbTableMap;
    }

    @Transaction(project=2)
    public void loadTable(TableDesc tableDesc, TableExtDesc extDesc, String project) {
        this.checkBeforeLoadTable(tableDesc, project);
        String loaded = this.tableService.loadTableToProject(tableDesc, extDesc, project);
        String tableName = tableDesc.getIdentity();
        if (loaded == null || !loaded.equals(tableName)) {
            throw new IllegalStateException();
        }
    }

    @Transaction(project=1)
    public void removeJobIdFromTableExt(String jobId, String project) {
        this.aclEvaluate.checkProjectOperationPermission(project);
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        for (TableDesc desc : tableMetadataManager.listAllTables()) {
            TableExtDesc extDesc = tableMetadataManager.getTableExtIfExists(desc);
            if (extDesc == null || (extDesc = tableMetadataManager.copyForWrite(extDesc)).getJodID() == null || !jobId.equals(extDesc.getJodID())) continue;
            extDesc.setJodID(null);
            tableMetadataManager.saveTableExt(extDesc);
        }
    }

    @Transaction(project=0, retry=1)
    public void checkAndLoadTable(String project, TableDesc tableDesc, TableExtDesc extDesc) {
        this.loadTable(tableDesc, extDesc, project);
    }

    private void checkBeforeLoadTable(TableDesc tableDesc, String project) {
        NTableMetadataManager tableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableDesc originTableDesc = tableMetadataManager.getTableDesc(tableDesc.getIdentity());
        if (originTableDesc != null && (originTableDesc.getSourceType() == 1 || tableDesc.getSourceType() == 1)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_TABLE_NAME, String.format(Locale.ROOT, MsgPicker.getMsg().getSameTableNameExist(), tableDesc.getIdentity()));
        }
    }

    public List<String> getTableNamesByFuzzyKey(String project, String fuzzyKey, boolean exact) {
        if (StringUtils.isNotEmpty((CharSequence)project)) {
            NTableMetadataManager nTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
            return this.matchTableNames(nTableMetadataManager, fuzzyKey, exact);
        }
        ArrayList<String> tableNames = new ArrayList<String>();
        List projectInstances = this.projectService.getReadableProjects(null, false);
        for (ProjectInstance projectInstance : projectInstances) {
            NTableMetadataManager nTableMetadataManager = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, projectInstance.getName());
            tableNames.addAll(this.matchTableNames(nTableMetadataManager, fuzzyKey, exact));
        }
        return tableNames;
    }

    private List<String> matchTableNames(NTableMetadataManager nTableMetadataManager, String fuzzyKey, boolean exact) {
        if (!exact) {
            return nTableMetadataManager.getTableNamesByFuzzyKey(fuzzyKey);
        }
        ArrayList tableIdentities = Lists.newArrayList();
        TableDesc tableDesc = nTableMetadataManager.getTableDesc(fuzzyKey);
        if (null != tableDesc) {
            tableIdentities.add(tableDesc.getIdentity());
        }
        return tableIdentities;
    }

    public List<ExcludedTableResponse> getExcludedTables(String project, boolean viewPartialCols, String tablePattern) {
        this.aclEvaluate.checkProjectReadPermission(project);
        this.checkTableExclusionEnabled(project);
        NTableMetadataManager tableMgr = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        return tableMgr.listAllTables().stream().map(arg_0 -> ((NTableMetadataManager)tableMgr).getTableExtIfExists(arg_0)).filter(Objects::nonNull).filter(tableExt -> tableExt.isExcluded() || !tableExt.getExcludedColumns().isEmpty()).filter(table -> StringUtils.isBlank((CharSequence)tablePattern) || StringUtils.containsIgnoreCase((CharSequence)table.getIdentity(), (CharSequence)tablePattern)).map(tableExt -> {
            TableDesc table = tableMgr.getTableDesc(tableExt.getIdentity());
            ExcludedTableResponse response = new ExcludedTableResponse();
            response.setExcluded(tableExt.isExcluded());
            response.setTable(tableExt.getIdentity());
            response.setExcludedColSize(tableExt.countExcludedColSize());
            response.setExcludedColumns(this.seekExcludedColumns(viewPartialCols, (TableExtDesc)tableExt, table));
            return response;
        }).collect(Collectors.toList());
    }

    private void checkTableExclusionEnabled(String project) {
        ProjectInstance prjInstance = ((NProjectManager)this.getManager(NProjectManager.class)).getProject(project);
        if (!prjInstance.getConfig().isTableExclusionEnabled()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.EXCLUDED_TABLE_REQUEST_NOT_ALLOWED, new Object[]{project});
        }
    }

    private List<String> seekExcludedColumns(boolean viewPartialCols, TableExtDesc tableExt, TableDesc table) {
        ColumnDesc[] columns = table.getColumns();
        int limit = viewPartialCols ? 15 : columns.length;
        return Arrays.stream(columns).filter(arg_0 -> ((TableExtDesc)tableExt).testExcluded(arg_0)).limit(limit).map(ColumnDesc::getName).collect(Collectors.toList());
    }

    public ExcludedTableDetailResponse getExcludedTable(String project, String table, int pageOffset, int pageSize, String colPattern, boolean matchExcludedCols) {
        this.aclEvaluate.checkProjectReadPermission(project);
        this.checkTableExclusionEnabled(project);
        NTableMetadataManager tableMgr = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        TableExtDesc tableExt = tableMgr.getOrCreateTableExt(table);
        List columnList = Arrays.stream(tableMgr.getTableDesc(table).getColumns()).filter(column -> StringUtils.isBlank((CharSequence)colPattern) || StringUtils.containsIgnoreCase((CharSequence)column.getName(), (CharSequence)colPattern)).filter(column -> matchExcludedCols == tableExt.testExcluded(column)).collect(Collectors.toList());
        DataResult dataResult = DataResult.get(columnList, (int)pageOffset, (int)pageSize);
        List columns = ((List)dataResult.getValue()).stream().map(column -> new ExcludedColumnResponse(column, matchExcludedCols)).collect(Collectors.toList());
        ExcludedTableDetailResponse response = new ExcludedTableDetailResponse();
        response.setTable(tableExt.getIdentity());
        response.setExcluded(tableExt.isExcluded());
        response.setTotalSize(dataResult.getTotalSize());
        response.setOffset(dataResult.getOffset());
        response.setLimit(dataResult.getLimit());
        if (matchExcludedCols) {
            response.setExcludedColumns(columns);
        } else {
            response.setAdmittedColumns(columns);
        }
        return response;
    }

    @Transaction(project=0)
    public void updateExcludedTables(String project, TableExclusionRequest request) {
        this.aclEvaluate.checkProjectReadPermission(project);
        this.checkTableExclusionEnabled(project);
        NTableMetadataManager tableMgr = (NTableMetadataManager)this.getManager(NTableMetadataManager.class, project);
        request.getCanceledTables().stream().map(StringUtils::upperCase).forEach(identity -> {
            boolean tableExtExist = tableMgr.isTableExtExist(identity);
            TableExtDesc tableExt = tableMgr.getOrCreateTableExt(identity);
            tableExt.setIdentity(identity);
            tableExt.setExcluded(false);
            tableExt.getExcludedColumns().clear();
            tableMgr.saveOrUpdateTableExt(tableExtExist, tableExt);
        });
        request.getExcludedTables().forEach(excludedTable -> {
            String excludedTableName = StringUtils.upperCase((String)excludedTable.getTable());
            boolean tableExtExist = tableMgr.isTableExtExist(excludedTableName);
            TableExtDesc tableExt = tableMgr.getOrCreateTableExt(excludedTableName);
            tableExt.setIdentity(excludedTableName);
            if (excludedTable.isExcluded()) {
                tableExt.getExcludedColumns().clear();
                tableExt.setExcluded(excludedTable.isExcluded());
            } else {
                TableDesc table = tableMgr.getTableDesc(tableExt.getIdentity());
                List<String> toBeRemovedColumns = excludedTable.getRemovedColumns().stream().map(StringUtils::upperCase).collect(Collectors.toList());
                List toBeAddedColumns = excludedTable.getAddedColumns().stream().map(StringUtils::upperCase).collect(Collectors.toList());
                if (tableExt.isExcluded()) {
                    Set colNameSet = Arrays.stream(table.getColumns()).map(ColumnDesc::getName).collect(Collectors.toSet());
                    toBeRemovedColumns.forEach(colNameSet::remove);
                    tableExt.getExcludedColumns().addAll(colNameSet);
                    tableExt.setExcluded(excludedTable.isExcluded());
                } else {
                    toBeAddedColumns.stream().map(StringUtils::upperCase).forEach(tableExt.getExcludedColumns()::add);
                    toBeRemovedColumns.forEach(tableExt.getExcludedColumns()::remove);
                    tableExt.setExcluded(excludedTable.isExcluded());
                }
                if (tableExt.getExcludedColumns().size() == table.getColumns().length) {
                    tableExt.getExcludedColumns().clear();
                    tableExt.setExcluded(true);
                }
            }
            tableMgr.saveOrUpdateTableExt(tableExtExist, tableExt);
        });
    }
}

