/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.ddl;

import java.io.Serializable;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.engine.spark.source.NSparkMetadataExplorer;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.rest.security.KerberosLoginManager;
import org.apache.spark.ddl.DDLCheck;
import org.apache.spark.ddl.DDLCheckContext;
import org.apache.spark.ddl.DDLConstant;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.execution.CommandExecutionMode$;
import org.apache.spark.sql.execution.CommandResultExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.AlterViewAsCommand;
import org.apache.spark.sql.execution.command.CreateViewCommand;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.apache.spark.sql.execution.command.ExecutedCommandExec;
import org.apache.spark.sql.execution.command.ShowCreateTableCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\n\u0015\u0001}AQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004<\u0001\u0001\u0006I!\u000e\u0005\by\u0001\u0011\r\u0011\"\u0003>\u0011\u0019\t\u0005\u0001)A\u0005}!9!\t\u0001b\u0001\n\u0013\u0019\u0005BB'\u0001A\u0003%A\tC\u0004O\u0001\t\u0007I\u0011B\u001f\t\r=\u0003\u0001\u0015!\u0003?\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015)\b\u0001\"\u0003w\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000fAq!a\u0004\u0001\t\u0003\t\t\u0002C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"!9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\"!\u0003,jK^\u001c\u0005.Z2l\u0015\t)b#A\u0002eI2T!a\u0006\r\u0002\tI,7\u000f\u001e\u0006\u00033i\tQa[=mS:T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!QA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005Y\u0006twMC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#AB(cU\u0016\u001cG\u000f\u0005\u0002*[5\t!F\u0003\u0002\u0016W)\u0011AFG\u0001\u0006gB\f'o[\u0005\u0003])\u0012\u0001\u0002\u0012#M\u0007\",7m[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003E\u0002\"A\r\u0001\u000e\u0003Q\ta\u0001T(H\u000f\u0016\u0013V#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0012!B:mMRR\u0017B\u0001\u001e8\u0005\u0019aunZ4fe\u00069AjT$H\u000bJ\u0003\u0013A\u0002)S\u000b\u001aK\u0005,F\u0001?!\t\ts(\u0003\u0002AE\t11\u000b\u001e:j]\u001e\fq\u0001\u0015*F\r&C\u0006%\u0001\u0004T\u001fV\u00136)R\u000b\u0002\tB\u0011QiS\u0007\u0002\r*\u0011q\tS\u0001\u0007g>,(oY3\u000b\u00051J%B\u0001&\u0019\u0003\u0019)gnZ5oK&\u0011AJ\u0012\u0002\u0017\u001dN\u0003\u0018M]6NKR\fG-\u0019;b\u000bb\u0004Hn\u001c:fe\u000691kT+S\u0007\u0016\u0003\u0013!\u0005'P\u000f&\u001b\u0015\tT0W\u0013\u0016;v\fV-Q\u000b\u0006\u0011BjT$J\u0007\u0006cuLV%F/~#\u0016\fU#!\u0003-!Wm]2sSB$\u0018n\u001c8\u0015\u0007I\u0013G\rE\u0002T-bk\u0011\u0001\u0016\u0006\u0002+\u0006)1oY1mC&\u0011q\u000b\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00033\u0002t!A\u00170\u0011\u0005m#V\"\u0001/\u000b\u0005us\u0012A\u0002\u001fs_>$h(\u0003\u0002`)\u00061\u0001K]3eK\u001aL!\u0001Q1\u000b\u0005}#\u0006\"B2\u000b\u0001\u0004A\u0016a\u00029s_*,7\r\u001e\u0005\u0006K*\u0001\r\u0001W\u0001\ta\u0006<W\rV=qK\u0006A\u0001O]5pe&$\u0018\u0010F\u0001i!\t\u0019\u0016.\u0003\u0002k)\n\u0019\u0011J\u001c;\u0002\u000b\rDWmY6\u0015\u00055\u0004\bCA*o\u0013\tyGK\u0001\u0003V]&$\b\"B9\r\u0001\u0004\u0011\u0018aB2p]R,\u0007\u0010\u001e\t\u0003SML!\u0001\u001e\u0016\u0003\u001f\u0011#Ej\u00115fG.\u001cuN\u001c;fqR\f!c\u00195fG.D\u0015N^3UC\ndWMT1nKR!Qn^A\u0002\u0011\u0015AX\u00021\u0001z\u0003)IG-\u001a8uS\u001aLWM\u001d\t\u0003u~l\u0011a\u001f\u0006\u0003yv\f\u0001bY1uC2L8\u000f\u001e\u0006\u0003}.\n1a]9m\u0013\r\t\ta\u001f\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\")\u0011/\u0004a\u0001e\u000692\r[3dW\"Kg/\u001a#bi\u0006\u0014\u0017m]3BG\u000e,7o\u001d\u000b\b[\u0006%\u00111BA\u0007\u0011\u0015Ah\u00021\u0001z\u0011\u0015\u0019g\u00021\u0001Y\u0011\u0015\th\u00021\u0001s\u0003]\u0019\u0007.Z2l\u0019><\u0017nY1m-&,wOT8u+N,G\rF\u0003n\u0003'\t9\u0002\u0003\u0004\u0002\u0016=\u0001\r!_\u0001\u000ei\u0006\u0014G.Z%eK:$\u0018\u000e^=\t\u000b\r|\u0001\u0019\u0001-\u000231L7\u000f^!mY\u0012\u000bG/\u00192bg\u0016\u001c\b*Y:BG\u000e,7o\u001d\u000b\u00041\u0006u\u0001\"B2\u0011\u0001\u0004A\u0016\u0001F2iK\u000e\\7i\\7nC:$'+Z:ue&\u001cG\u000fF\u0002n\u0003GAQ!]\tA\u0002I\fac\u001d;sSB\u0014vn\u001c;D_6l\u0017M\u001c3SKN,H\u000e\u001e\u000b\u0005\u0003S\t)\u0004\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#`\u0001\nKb,7-\u001e;j_:LA!a\r\u0002.\tI1\u000b]1sWBc\u0017M\u001c\u0005\b\u0003o\u0011\u0002\u0019AA\u0015\u00031)\u00070Z2vi\u0016$\u0007\u000b\\1o\u0001")
public class ViewCheck
implements DDLCheck {
    private final Logger LOGGER = LoggerFactory.getLogger(ViewCheck.class);
    private final String PREFIX;
    private final NSparkMetadataExplorer org$apache$kylin$rest$ddl$ViewCheck$$SOURCE = new NSparkMetadataExplorer();
    private final String LOGICAL_VIEW_TYPE;

    public void throwException(String x$1) {
        super.throwException(x$1);
    }

    public int compareTo(DDLCheck x$1) {
        return super.compareTo(x$1);
    }

    private Logger LOGGER() {
        return this.LOGGER;
    }

    private String PREFIX() {
        return this.PREFIX;
    }

    public NSparkMetadataExplorer org$apache$kylin$rest$ddl$ViewCheck$$SOURCE() {
        return this.org$apache$kylin$rest$ddl$ViewCheck$$SOURCE;
    }

    private String LOGICAL_VIEW_TYPE() {
        return this.LOGICAL_VIEW_TYPE;
    }

    public String[] description(String project, String pageType) {
        StringBuilder stringBuilder;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        StringBuilder cnDescription = new StringBuilder();
        StringBuilder enDescription = new StringBuilder();
        StringBuilder databasesHasAccess = new StringBuilder();
        StringBuilder syntaxSupport = new StringBuilder();
        if ("hive".equalsIgnoreCase(pageType)) {
            databasesHasAccess.append(this.listAllDatabasesHasAccess(project));
            syntaxSupport.append("`create view`,`alter view`,`drop view`,`show create table`");
            cnDescription.append("Hive View \u540d\u79f0\u9700\u8981\u4ee5 `KYLIN_` \u5f00\u5934\t");
            enDescription.append("Hive View name should start with `KYLIN_`\t");
            cnDescription.append(new java.lang.StringBuilder(8).append("\u4ec5\u652f\u6301 ").append((CharSequence)syntaxSupport).append(" \u8bed\u6cd5\t").toString());
            enDescription.append(new java.lang.StringBuilder(22).append("Only supports ").append((CharSequence)syntaxSupport).append(" syntax\t").toString());
            cnDescription.append(new java.lang.StringBuilder(25).append("\u4ec5\u652f\u6301\u521b\u5efa Hive View \u5728\u5982\u4e0b\u6570\u636e\u5e93: ").append((CharSequence)databasesHasAccess).append("\t").toString());
            stringBuilder = enDescription.append(new java.lang.StringBuilder(38).append("Only supports creating Hive Views in ").append((CharSequence)databasesHasAccess).append("\t").toString());
        } else {
            cnDescription.append(new java.lang.StringBuilder(41).append("\u521b\u5efa\u4e0d\u8981\u52a0 database \u540d\u79f0\uff0c\u7cfb\u7edf\u81ea\u52a8\u521b\u5efa\u5230 ").append(config.getDDLLogicalViewDB()).append(" \u5e93\u4e2d\uff0c").append("\u5220\u9664\u8981\u52a0 ").append(config.getDDLLogicalViewDB()).append(" \u5e93\u540d\u79f0 \t").toString());
            enDescription.append(new java.lang.StringBuilder(175).append("When creating a new Logical View,please do not use database name,it will be automatically").append(" created in ").append(config.getDDLLogicalViewDB()).append(" database. When dropping a Logical View,").append("please add ").append(config.getDDLLogicalViewDB()).append(" database name in SQL.\t").toString());
            syntaxSupport.append(" `create logical view`, `drop logical view` ");
            cnDescription.append(new java.lang.StringBuilder(8).append("\u4ec5\u652f\u6301 ").append((CharSequence)syntaxSupport).append(" \u8bed\u6cd5\t").toString());
            enDescription.append(new java.lang.StringBuilder(43).append("Only ").append((CharSequence)syntaxSupport).append(" SQL sentences are allowed to execute\t").toString());
            cnDescription.append(new java.lang.StringBuilder(125).append("\u64cd\u4f5c\u4e3e\u4f8b\uff1a\n\u521b\u5efa\u89c6\u56fe\uff1aCREATE LOGICAL VIEW your_logical_view AS select * from your_loaded_table\n").append("\u5220\u9664\u89c6\u56fe\uff1aDROP LOGICAL VIEW ").append(config.getDDLLogicalViewDB()).append(".your_logical_view").toString());
            stringBuilder = enDescription.append(new java.lang.StringBuilder(143).append("Operation Examples:\nCreate:CREATE LOGICAL VIEW your_logical_view AS select * from your_loaded_table").append(";\nDrop:DROP LOGICAL VIEW ").append(config.getDDLLogicalViewDB()).append(".your_logical_view;").toString());
        }
        return (String[])((Object[])new String[]{enDescription.toString(), cnDescription.toString()});
    }

    public int priority() {
        return Predef$.MODULE$.Integer2int(DDLConstant.VIEW_RULE_PRIORITY);
    }

    /*
     * Unable to fully structure code
     */
    public void check(DDLCheckContext context) {
        this.LOGGER().info("start checking DDL view name");
        sql = context.getSql();
        project = context.getProject();
        spark = SparderEnv$.MODULE$.getSparkSession();
        config = KylinConfig.getInstanceFromEnv();
        plan = null;
        try {
            sql = LogicalViewLoader.addCatalog((String)context.getSql(), (String)context.getProject(), (SparkSession)SparderEnv$.MODULE$.getSparkSession());
            logicalPlan = spark.sessionState().sqlParser().parsePlan(sql);
            plan = this.stripRootCommandResult(spark.sessionState().executePlan(logicalPlan, CommandExecutionMode$.MODULE$.SKIP()).executedPlan());
        }
        catch (Exception e) {
            this.throwException(e.getMessage());
        }
        var10_9 = false;
        var11_10 = null;
        var12_11 = plan;
        if (!(var12_11 instanceof ExecutedCommandExec)) ** GOTO lbl-1000
        var10_9 = true;
        var11_10 = (ExecutedCommandExec)var12_11;
        view = var11_10.cmd();
        if (view instanceof CreateViewCommand) {
            var14_13 = (CreateViewCommand)view;
            if (var14_13.viewType() != null && this.LOGICAL_VIEW_TYPE().equalsIgnoreCase(var14_13.viewType().toString())) {
                viewManager = LogicalViewManager.getInstance((KylinConfig)config);
                originTable = viewManager.get(var14_13.name().table());
                if (var14_13.replace()) {
                    context.setCommandType("replaceLogicalView");
                    if (originTable == null) {
                        this.throwException("View name is not found.");
                    }
                    if (!originTable.getCreatedProject().equals(context.getProject())) {
                        this.throwException(new java.lang.StringBuilder(34).append("View can only modified in Project ").append(originTable.getCreatedProject()).toString());
                    }
                } else {
                    if (originTable != null) {
                        this.throwException(MsgPicker.getMsg().getDDLViewNameDuplicateError());
                    }
                    context.setCommandType("createLogicalView");
                }
                context.setLogicalViewName(var14_13.name().table());
                v0 = BoxedUnit.UNIT;
            } else {
                this.checkHiveTableName(var14_13.name(), context);
                this.checkHiveDatabaseAccess(var14_13.name(), project, context);
                v0 = BoxedUnit.UNIT;
            }
            var2_16 = v0;
        } else if (var10_9 && (view = var11_10.cmd()) instanceof ShowCreateTableCommand) {
            var18_22 = (ShowCreateTableCommand)view;
            this.checkHiveTableName(var18_22.table(), context);
            this.checkHiveDatabaseAccess(var18_22.table(), project, context);
            var2_17 = BoxedUnit.UNIT;
        } else if (var10_9 && (table = var11_10.cmd()) instanceof DropTableCommand) {
            var20_24 = (DropTableCommand)table;
            if (!var20_24.isView()) {
                this.throwException(MsgPicker.getMsg().getDDLDropError());
            }
            tableIdentifier = var20_24.tableName();
            if (config.isDDLLogicalViewEnabled() && tableIdentifier.database().isDefined() && config.getDDLLogicalViewDB().equalsIgnoreCase((String)tableIdentifier.database().get())) {
                context.setCommandType("dropLogicalView");
                context.setLogicalViewName(tableIdentifier.table());
                this.checkLogicalViewNotUsed(tableIdentifier, context.getProject());
                v1 = BoxedUnit.UNIT;
            } else {
                this.checkHiveTableName(var20_24.tableName(), context);
                this.checkHiveDatabaseAccess(var20_24.tableName(), project, context);
                v1 = BoxedUnit.UNIT;
            }
            var2_18 = v1;
        } else if (var10_9 && (table = var11_10.cmd()) instanceof AlterViewAsCommand) {
            var23_27 = (AlterViewAsCommand)table;
            this.checkHiveTableName(var23_27.name(), context);
            this.checkHiveDatabaseAccess(var23_27.name(), project, context);
            var2_19 = BoxedUnit.UNIT;
        } else {
            this.throwException(MsgPicker.getMsg().getDDLUnSupported());
            var2_20 = BoxedUnit.UNIT;
        }
        if (context.isLogicalViewCommand() && !config.isDDLLogicalViewEnabled()) {
            this.throwException("Logical View operation is not supported, please turn on config.");
        }
        if (context.isHiveCommand() && !config.isDDLHiveEnabled()) {
            this.throwException("Hive operation is not supported, please turn on config.");
        }
        this.checkCommandRestrict(context);
    }

    private void checkHiveTableName(TableIdentifier identifier, DDLCheckContext context) {
        block0: {
            if (identifier.table().toUpperCase(Locale.ROOT).startsWith(this.PREFIX())) break block0;
            this.throwException(MsgPicker.getMsg().getDDLViewNameError());
        }
    }

    public void checkHiveDatabaseAccess(TableIdentifier identifier, String project, DDLCheckContext context) {
        block3: {
            UserGroupInformation ugi;
            boolean hasDatabaseAccess;
            String database;
            if (!context.isKerberosEnv() && !KylinConfig.getInstanceFromEnv().isUTEnv()) {
                return;
            }
            if (identifier.database().isEmpty()) {
                this.throwException("Missing Databases name in sql.");
            }
            if ((database = (String)identifier.database().get()).equalsIgnoreCase(KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB())) {
                this.throwException("Shouldn't use logical view database.");
            }
            if (hasDatabaseAccess = BoxesRunTime.unboxToBoolean((Object)(ugi = KerberosLoginManager.getInstance().getProjectUGI(project)).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(this, database){
                private final /* synthetic */ ViewCheck $outer;
                private final String database$1;

                public boolean run() {
                    return this.$outer.org$apache$kylin$rest$ddl$ViewCheck$$SOURCE().checkDatabaseHadoopAccessFast(this.database$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.database$1 = database$1;
                }
            }))) break block3;
            this.throwException(MsgPicker.getMsg().getDDLDatabaseAccessnDenied());
        }
    }

    public void checkLogicalViewNotUsed(TableIdentifier tableIdentity, String project) {
        block0: {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            String db = config.getDDLLogicalViewDB();
            String viewName = tableIdentity.table();
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
            ((IterableLike)ImplicitConversions$.MODULE$.map$u0020AsScala(tableManager.listTablesGroupBySchema()).filter((Function1 & Serializable & scala.Serializable)dbInfo -> BoxesRunTime.boxToBoolean((boolean)ViewCheck.$anonfun$checkLogicalViewNotUsed$1(db, dbInfo)))).foreach((Function1 & Serializable & scala.Serializable)dbInfo -> {
                ViewCheck.$anonfun$checkLogicalViewNotUsed$2(this, viewName, project, dbInfo);
                return BoxedUnit.UNIT;
            });
            LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)config);
            LogicalView originTable = viewManager.get(viewName);
            if (originTable == null || originTable.getCreatedProject().equalsIgnoreCase(project)) break block0;
            this.throwException(new java.lang.StringBuilder(34).append("View can only modified in Project ").append(originTable.getCreatedProject()).toString());
        }
    }

    public String listAllDatabasesHasAccess(String project) {
        boolean shouldCheckKerberosAccess = UserGroupInformation.isSecurityEnabled();
        UserGroupInformation ugi = KerberosLoginManager.getInstance().getProjectUGI(project);
        List databasesHasAccess = (List)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<String>>(this, shouldCheckKerberosAccess){
            private final /* synthetic */ ViewCheck $outer;
            private final boolean shouldCheckKerberosAccess$1;

            public List<String> run() {
                java.util.List databases = this.$outer.org$apache$kylin$rest$ddl$ViewCheck$$SOURCE().listDatabases();
                ListBuffer databasesHasAccess = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                databases.forEach(db -> {
                    block0: {
                        if ($this.shouldCheckKerberosAccess$1 && !$this.$outer.org$apache$kylin$rest$ddl$ViewCheck$$SOURCE().checkDatabaseHadoopAccessFast(db)) break block0;
                        databasesHasAccess.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{db}));
                    }
                });
                return databasesHasAccess.toList();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.shouldCheckKerberosAccess$1 = shouldCheckKerberosAccess$1;
            }
        });
        return databasesHasAccess.mkString(",");
    }

    public void checkCommandRestrict(DDLCheckContext context) {
        block2: {
            String restrict;
            block4: {
                String commandType;
                block3: {
                    block1: {
                        restrict = context.getRestrict();
                        commandType = context.getCommandType();
                        if (StringUtils.isBlank((CharSequence)restrict)) {
                            return;
                        }
                        if (!restrict.equalsIgnoreCase("logic") || commandType.equalsIgnoreCase("createLogicalView") || commandType.equalsIgnoreCase("dropLogicalView")) break block1;
                        this.throwException(MsgPicker.getMsg().getDDLRestrictError("`create logical view`, `drop logical view`"));
                        break block2;
                    }
                    if (!restrict.equalsIgnoreCase("replaceLogicalView") || restrict.equalsIgnoreCase(commandType)) break block3;
                    this.throwException(MsgPicker.getMsg().getDDLRestrictError("`replace logical view`"));
                    break block2;
                }
                if (!restrict.equalsIgnoreCase("hive") || restrict.equalsIgnoreCase(commandType)) break block4;
                this.throwException(MsgPicker.getMsg().getDDLRestrictError("`create view`,`alter view`,`drop view`,`show create table`"));
                break block2;
            }
            if (restrict.equalsIgnoreCase("hive") || restrict.equalsIgnoreCase("logic") || restrict.equalsIgnoreCase("replaceLogicalView")) break block2;
            this.throwException(new java.lang.StringBuilder(18).append("illegal restrict: ").append(restrict).toString());
        }
    }

    private SparkPlan stripRootCommandResult(SparkPlan executedPlan) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = executedPlan;
        if (sparkPlan2 instanceof CommandResultExec) {
            SparkPlan plan;
            CommandResultExec commandResultExec = (CommandResultExec)sparkPlan2;
            sparkPlan = plan = commandResultExec.commandPhysicalPlan();
        } else {
            sparkPlan = sparkPlan2;
        }
        return sparkPlan;
    }

    public static final /* synthetic */ boolean $anonfun$checkLogicalViewNotUsed$1(String db$1, Tuple2 dbInfo) {
        return ((String)dbInfo._1()).equalsIgnoreCase(db$1);
    }

    public static final /* synthetic */ boolean $anonfun$checkLogicalViewNotUsed$3(String viewName$1, TableDesc loadTable) {
        return loadTable.getName().equalsIgnoreCase(viewName$1);
    }

    public static final /* synthetic */ void $anonfun$checkLogicalViewNotUsed$2(ViewCheck $this, String viewName$1, String project$1, Tuple2 dbInfo) {
        block0: {
            boolean isExist = ImplicitConversions$.MODULE$.collection$u0020AsScalaIterable((Collection)dbInfo._2()).exists((Function1 & Serializable & scala.Serializable)loadTable -> BoxesRunTime.boxToBoolean((boolean)ViewCheck.$anonfun$checkLogicalViewNotUsed$3(viewName$1, loadTable)));
            if (!isExist) break block0;
            $this.throwException(MsgPicker.getMsg().getDDLLogicalViewHasUsed(viewName$1, project$1));
        }
    }

    public ViewCheck() {
        this.PREFIX = "KYLIN_";
        this.LOGICAL_VIEW_TYPE = "GlobalTempView";
    }
}

