/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.sdk.datasource.adaptor.AbstractJdbcAdaptor;
import org.apache.kylin.sdk.datasource.framework.conv.ConvMaster;
import org.apache.kylin.sdk.datasource.framework.conv.DefaultConfigurer;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDefProvider;
import org.apache.kylin.source.SupportsSparkCatalog;

public class JdbcConnector
implements Closeable,
SupportsSparkCatalog {
    private final AbstractJdbcAdaptor adaptor;
    private SqlConverter sqlConverter;
    private DataSourceDef jdbcDs;
    private ConvMaster convMaster;

    public JdbcConnector(AbstractJdbcAdaptor adaptor) throws SQLException {
        this.adaptor = adaptor;
        DataSourceDefProvider provider = DataSourceDefProvider.getInstance();
        this.jdbcDs = provider.getById(this.adaptor.getDataSourceId());
        DataSourceDef kylinDs = provider.getDefault();
        this.convMaster = new ConvMaster(kylinDs, this.jdbcDs);
        DefaultConfigurer configurer = new DefaultConfigurer(this.adaptor, this.jdbcDs);
        this.sqlConverter = new SqlConverter(configurer, this.convMaster);
    }

    public String getJdbcUrl() {
        return this.adaptor.getJdbcUrl();
    }

    public String getJdbcDriver() {
        return this.adaptor.getJdbcDriver();
    }

    public String getJdbcUser() {
        return this.adaptor.getJdbcUser();
    }

    public String getJdbcPassword() {
        return this.adaptor.getJdbcPassword();
    }

    @VisibleForTesting
    public AbstractJdbcAdaptor getAdaptor() {
        return this.adaptor;
    }

    public String convertSql(String orig) {
        return this.sqlConverter.convertSql(orig);
    }

    public String convertColumn(String column, String originQuote) {
        return this.sqlConverter.convertColumn(column, originQuote);
    }

    public String formatDateColumn(String column, DataType colType, String format) {
        return this.sqlConverter.formatDateColumn(column, colType, format);
    }

    public String convertSqoopSql(String orig, String partColumn, DataType partColType, String partColFormat) {
        String converted = this.sqlConverter.convertDateCondition(orig, partColumn, partColType, partColFormat);
        return this.sqlConverter.convertSql(converted);
    }

    public void testSql(String sql) throws Exception {
        this.adaptor.executeUpdate(sql);
    }

    public int toKylinTypeId(String sourceTypeName, int sourceTypeId) {
        Integer kylinTypeId = this.jdbcDs.getDataTypeValue(sourceTypeName);
        return kylinTypeId != null ? kylinTypeId.intValue() : this.adaptor.toKylinTypeId(sourceTypeName, sourceTypeId);
    }

    public String toKylinTypeName(int sourceTypeId) {
        return this.adaptor.toKylinTypeName(sourceTypeId);
    }

    public void executeUpdate(String sql) throws SQLException {
        this.adaptor.executeUpdate(sql);
    }

    public void executeUpdate(String[] sqls) throws SQLException {
        this.adaptor.executeUpdate(sqls);
    }

    public List<String> listDatabases() throws SQLException {
        List<String> dbNames = this.adaptor.listDatabasesWithCache(true);
        String blackList = this.jdbcDs.getPropertyValue("schema.database.black-list-pattern");
        if (!StringUtils.isEmpty((CharSequence)blackList)) {
            String[] patterns = blackList.split(",");
            LinkedList removed = Lists.newLinkedList();
            for (String p : patterns) {
                Pattern ptn = Pattern.compile(p.trim(), 2);
                for (String name : dbNames) {
                    if (!ptn.matcher(name).matches()) continue;
                    removed.add(name);
                }
            }
            dbNames.removeAll(removed);
        }
        return dbNames;
    }

    public List<String> listTables(String schema) throws SQLException {
        return this.adaptor.listTablesWithCache(schema, true);
    }

    public CachedRowSet getTable(String database, String table) throws SQLException {
        return this.adaptor.getTable(database, table);
    }

    public CachedRowSet listColumns(String database, String table) throws SQLException {
        return this.adaptor.getTableColumns(database, table);
    }

    public String[] buildSqlToCreateSchema(String schemaName) {
        return this.adaptor.buildSqlToCreateSchema(schemaName);
    }

    public String[] buildSqlToLoadDataFromLocal(String tableName, String tableFileDir) {
        return this.adaptor.buildSqlToLoadDataFromLocal(tableName, tableFileDir);
    }

    public String[] buildSqlToCreateTable(String identity, LinkedHashMap<String, String> columnInfo) {
        return this.adaptor.buildSqlToCreateTable(identity, columnInfo);
    }

    public String[] buildSqlToCreateView(String viewName, String s) {
        return this.adaptor.buildSqlToCreateView(viewName, s);
    }

    public Connection getConnection() throws SQLException {
        return this.adaptor.getConnection();
    }

    public String addCatalog(KylinConfig config, String sql, String project) {
        return this.adaptor.addCatalog(config, sql, project);
    }

    public Map<String, String> getSourceCatalogConf(KylinConfig config, String project) {
        return this.adaptor.getSourceCatalogConf(config, project);
    }

    public Connection getConnectionWithDefaultDb(String dbName) throws SQLException {
        return this.adaptor.getConnectionWithDefaultDB(dbName);
    }

    public String getPropertyValue(String key, String defaultValue) {
        return this.jdbcDs.getPropertyValue(key, defaultValue);
    }

    public String getPropertyValue(String key) {
        return this.jdbcDs.getPropertyValue(key);
    }

    public SqlConverter getSqlConverter() {
        return this.sqlConverter;
    }

    @Override
    public void close() throws IOException {
        if (this.adaptor != null) {
            this.adaptor.close();
        }
    }
}

