/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kudu.shaded.org.apache.commons.io.FileUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TempDirUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TempDirUtils.class);

    public static File makeTempDirectory(String prefix, DeleteOnExit deleteRecursivelyOnExit) throws IOException {
        File newDir;
        String testTmpdir = System.getenv("TEST_TMPDIR");
        if (testTmpdir != null) {
            LOG.info("Using the temp directory defined by TEST_TMPDIR: " + testTmpdir);
            newDir = Files.createTempDirectory(Paths.get(testTmpdir, new String[0]), prefix, new FileAttribute[0]).toFile();
        } else {
            newDir = Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
        }
        if (deleteRecursivelyOnExit == DeleteOnExit.DELETE_RECURSIVELY_ON_EXIT) {
            TempDirUtils.registerToRecursivelyDeleteOnShutdown(newDir.toPath());
        }
        return newDir;
    }

    private static void registerToRecursivelyDeleteOnShutdown(Path path) {
        final Path absPath = path.toAbsolutePath();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                File dir = absPath.toFile();
                if (!dir.exists()) {
                    return;
                }
                try {
                    FileUtils.deleteDirectory(dir);
                }
                catch (IOException exc) {
                    LOG.warn("Unable to remove directory tree " + absPath.toString(), (Throwable)exc);
                }
            }
        });
    }

    public static enum DeleteOnExit {
        NO_DELETE_ON_EXIT,
        DELETE_RECURSIVELY_ON_EXIT;

    }
}

