/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Iterator;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduScannerIterator
implements Iterator<RowResult> {
    private final KuduScanner scanner;
    private final long keepAlivePeriodMs;
    private RowResultIterator currentIterator = RowResultIterator.empty();
    private long lastKeepAliveTimeMs = System.currentTimeMillis();

    KuduScannerIterator(KuduScanner scanner, long keepAlivePeriodMs) {
        this.scanner = scanner;
        this.keepAlivePeriodMs = keepAlivePeriodMs;
    }

    private void KeepKuduScannerAlive() throws KuduException {
        long now = System.currentTimeMillis();
        if (now >= this.lastKeepAliveTimeMs + this.keepAlivePeriodMs && !this.scanner.isClosed()) {
            this.scanner.keepAlive();
            this.lastKeepAliveTimeMs = now;
        }
    }

    @InterfaceAudience.LimitedPrivate(value={"Spark"})
    public boolean hasNext(NextRowsCallback nextRowsCallback) {
        try {
            while (!this.currentIterator.hasNext() && this.scanner.hasMoreRows()) {
                this.currentIterator = this.scanner.nextRows();
                if (nextRowsCallback == null) continue;
                nextRowsCallback.call(this.currentIterator.getNumRows());
            }
            this.KeepKuduScannerAlive();
            return this.currentIterator.hasNext();
        }
        catch (KuduException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(null);
    }

    @Override
    public RowResult next() {
        return this.currentIterator.next();
    }

    @InterfaceAudience.LimitedPrivate(value={"Spark"})
    public static abstract class NextRowsCallback {
        public abstract void call(int var1);
    }
}

