/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.List;
import java.util.Map;
import org.apache.kudu.Common;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.master.Master;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.base.Strings;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class CreateTableOptions {
    private final List<PartialRow> splitRows = Lists.newArrayList();
    private final List<RangePartition> rangePartitions = Lists.newArrayList();
    private Master.CreateTableRequestPB.Builder pb = Master.CreateTableRequestPB.newBuilder();
    private boolean wait = true;

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets) {
        this.addHashPartitions(columns, buckets, 0);
        return this;
    }

    public CreateTableOptions addHashPartitions(List<String> columns, int buckets, int seed) {
        Common.PartitionSchemaPB.HashBucketSchemaPB.Builder hashBucket = this.pb.getPartitionSchemaBuilder().addHashBucketSchemasBuilder();
        for (String column : columns) {
            hashBucket.addColumnsBuilder().setName(column);
        }
        hashBucket.setNumBuckets(buckets);
        hashBucket.setSeed(seed);
        return this;
    }

    public CreateTableOptions setRangePartitionColumns(List<String> columns) {
        Common.PartitionSchemaPB.RangeSchemaPB.Builder rangePartition = this.pb.getPartitionSchemaBuilder().getRangeSchemaBuilder();
        for (String column : columns) {
            rangePartition.addColumnsBuilder().setName(column);
        }
        return this;
    }

    public CreateTableOptions addRangePartition(PartialRow lower, PartialRow upper) {
        return this.addRangePartition(lower, upper, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public CreateTableOptions addRangePartition(PartialRow lower, PartialRow upper, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        this.rangePartitions.add(new RangePartition(lower, upper, lowerBoundType, upperBoundType));
        return this;
    }

    public CreateTableOptions addSplitRow(PartialRow row) {
        this.splitRows.add(new PartialRow(row));
        return this;
    }

    public CreateTableOptions setNumReplicas(int numReplicas) {
        this.pb.setNumReplicas(numReplicas);
        return this;
    }

    public CreateTableOptions setExtraConfigs(Map<String, String> extraConfig) {
        this.pb.putAllExtraConfigs(extraConfig);
        return this;
    }

    public CreateTableOptions setWait(boolean wait) {
        this.wait = wait;
        return this;
    }

    @InterfaceAudience.LimitedPrivate(value={"Impala"})
    @InterfaceStability.Unstable
    public CreateTableOptions setOwner(String owner) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(owner), "table owner must not be null or empty");
        this.pb.setOwner(owner);
        return this;
    }

    Master.CreateTableRequestPB.Builder getBuilder() {
        if (!this.splitRows.isEmpty() || !this.rangePartitions.isEmpty()) {
            this.pb.setSplitRowsRangeBounds(new Operation.OperationsEncoder().encodeRangePartitions(this.rangePartitions, this.splitRows));
        }
        return this.pb;
    }

    List<Integer> getRequiredFeatureFlags() {
        if (this.rangePartitions.isEmpty()) {
            return ImmutableList.of();
        }
        return ImmutableList.of(Integer.valueOf(1));
    }

    boolean shouldWait() {
        return this.wait;
    }

    static final class RangePartition {
        private final PartialRow lowerBound;
        private final PartialRow upperBound;
        private final RangePartitionBound lowerBoundType;
        private final RangePartitionBound upperBoundType;

        public RangePartition(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.lowerBoundType = lowerBoundType;
            this.upperBoundType = upperBoundType;
        }

        public PartialRow getLowerBound() {
            return this.lowerBound;
        }

        public PartialRow getUpperBound() {
            return this.upperBound;
        }

        public RangePartitionBound getLowerBoundType() {
            return this.lowerBoundType;
        }

        public RangePartitionBound getUpperBoundType() {
            return this.upperBoundType;
        }
    }
}

