/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.mapreduce;

import com.google.common.base.Preconditions;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.kudu.client.ColumnRangePredicate;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.Operation;
import org.apache.kudu.mapreduce.CommandLineParser;
import org.apache.kudu.mapreduce.JarFinder;
import org.apache.kudu.mapreduce.KuduTableInputFormat;
import org.apache.kudu.mapreduce.KuduTableOutputFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduTableMapReduceUtil {
    private static final Log LOG = LogFactory.getLog(KuduTableMapReduceUtil.class);
    private static final Text AUTHN_CREDENTIALS_ALIAS = new Text("kudu.authn.credentials");
    private static final Text KUDU_TOKEN_KIND = new Text("kudu-authn-data");

    private KuduTableMapReduceUtil() {
    }

    static String base64EncodePredicates(List<KuduPredicate> predicates) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (KuduPredicate predicate : predicates) {
            predicate.toPB().writeDelimitedTo((OutputStream)baos);
        }
        return Base64.encodeBase64String((byte[])baos.toByteArray());
    }

    public static KuduTable getTableFromContext(TaskInputOutputContext context) {
        String multitonKey = context.getConfiguration().get("kudu.mapreduce.multitonkey");
        return KuduTableOutputFormat.getKuduTable(multitonKey);
    }

    public static void addCredentialsToJob(KuduClient client, Job job) throws KuduException {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)job);
        byte[] authnCreds = client.exportAuthenticationCredentials();
        Text service = new Text(client.getMasterAddressesAsString());
        job.getCredentials().addToken(AUTHN_CREDENTIALS_ALIAS, new Token(null, authnCreds, KUDU_TOKEN_KIND, service));
    }

    public static void importCredentialsFromCurrentSubject(KuduClient client) {
        Subject subj = Subject.getSubject(AccessController.getContext());
        if (subj == null) {
            return;
        }
        Text service = new Text(client.getMasterAddressesAsString());
        Set<Credentials> credSet = subj.getPrivateCredentials(Credentials.class);
        if (credSet == null) {
            return;
        }
        for (Credentials creds : credSet) {
            for (Token tok : creds.getAllTokens()) {
                if (!tok.getKind().equals((Object)KUDU_TOKEN_KIND)) continue;
                if (!tok.getService().equals((Object)service)) {
                    LOG.debug((Object)("Not importing credentials for service " + service + "(expecting service " + service + ")"));
                    continue;
                }
                LOG.debug((Object)("Importing credentials for service " + service));
                client.importAuthenticationCredentials(tok.getPassword());
                return;
            }
        }
    }

    public static void addDependencyJars(Job job) throws IOException {
        KuduTableMapReduceUtil.addKuduDependencyJars(job.getConfiguration());
        try {
            KuduTableMapReduceUtil.addDependencyJars(job.getConfiguration(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = KuduTableMapReduceUtil.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn((Object)("Could not find jar for class " + clazz + " in order to ship it to the cluster."));
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn((Object)("Could not validate jar file " + path + " for class " + clazz));
                continue;
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    public static void addKuduDependencyJars(Configuration conf) throws IOException {
        KuduTableMapReduceUtil.addDependencyJars(conf, Operation.class, KuduTableMapReduceUtil.class, Deferred.class);
    }

    private static Path findOrCreateJar(Class<?> myClass, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = KuduTableMapReduceUtil.findContainingJar(myClass, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = JarFinder.getJar(myClass);
            KuduTableMapReduceUtil.updateMap(jar, packagedClasses);
        }
        if (null == jar || jar.isEmpty()) {
            return null;
        }
        LOG.debug((Object)String.format("For class %s, using jar %s", myClass.getName(), jar));
        return new Path(jar).makeQualified(fs);
    }

    private static String findContainingJar(Class<?> myClass, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = myClass.getClassLoader();
        String classFile = myClass.getName().replaceAll("\\.", "/") + ".class";
        Enumeration<URL> itr = loader.getResources(classFile);
        while (itr.hasMoreElements()) {
            URL url = itr.nextElement();
            if (!"jar".equals(url.getProtocol())) continue;
            String toReturn = url.getPath();
            if (toReturn.startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = toReturn.replaceAll("\\+", "%2B");
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        return packagedClasses.get(classFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (null == jar || jar.isEmpty()) {
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(jar);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
        finally {
            if (null != zip) {
                zip.close();
            }
        }
    }

    public static class TableInputFormatConfiguratorWithCommandLineParser
    extends AbstractTableInputFormatConfigurator<TableInputFormatConfiguratorWithCommandLineParser> {
        public TableInputFormatConfiguratorWithCommandLineParser(Job job, String table, String columnProjection) {
            super(job, table, columnProjection);
            CommandLineParser parser = new CommandLineParser(job.getConfiguration());
            this.masterAddresses = parser.getMasterAddresses();
            this.operationTimeoutMs = parser.getOperationTimeoutMs();
        }
    }

    public static class TableInputFormatConfigurator
    extends AbstractTableInputFormatConfigurator<TableInputFormatConfigurator> {
        public TableInputFormatConfigurator(Job job, String table, String columnProjection, String masterAddresses) {
            super(job, table, columnProjection);
            this.masterAddresses = masterAddresses;
        }

        public TableInputFormatConfigurator operationTimeoutMs(long operationTimeoutMs) {
            if (operationTimeoutMs < 0L) {
                throw new IllegalArgumentException("The operation timeout must be => 0, passed value is: " + operationTimeoutMs);
            }
            this.operationTimeoutMs = operationTimeoutMs;
            return this;
        }

        @Deprecated
        public TableInputFormatConfigurator addColumnRangePredicate(ColumnRangePredicate predicate) {
            return this.addPredicate(predicate.toKuduPredicate());
        }

        public TableInputFormatConfigurator addPredicate(KuduPredicate predicate) {
            this.predicates.add(predicate);
            return this;
        }
    }

    public static class TableOutputFormatConfiguratorWithCommandLineParser
    extends AbstractTableOutputFormatConfigurator<TableOutputFormatConfiguratorWithCommandLineParser> {
        public TableOutputFormatConfiguratorWithCommandLineParser(Job job, String table) {
            super(job, table);
            CommandLineParser parser = new CommandLineParser(job.getConfiguration());
            this.masterAddresses = parser.getMasterAddresses();
            this.operationTimeoutMs = parser.getOperationTimeoutMs();
        }
    }

    public static class TableOutputFormatConfigurator
    extends AbstractTableOutputFormatConfigurator<TableOutputFormatConfigurator> {
        public TableOutputFormatConfigurator(Job job, String table, String masterAddresses) {
            super(job, table);
            this.masterAddresses = masterAddresses;
        }

        public TableOutputFormatConfigurator operationTimeoutMs(long operationTimeoutMs) {
            if (operationTimeoutMs < 0L) {
                throw new IllegalArgumentException("The operation timeout must be => 0, passed value is: " + operationTimeoutMs);
            }
            this.operationTimeoutMs = operationTimeoutMs;
            return this;
        }
    }

    private static abstract class AbstractTableInputFormatConfigurator<S extends AbstractTableInputFormatConfigurator<? super S>>
    extends AbstractMapReduceConfigurator<S> {
        protected String masterAddresses;
        protected long operationTimeoutMs = 30000L;
        protected final String columnProjection;
        protected boolean cacheBlocks;
        protected boolean isFaultTolerant;
        protected List<KuduPredicate> predicates = new ArrayList<KuduPredicate>();

        private AbstractTableInputFormatConfigurator(Job job, String table, String columnProjection) {
            super(job, table);
            this.columnProjection = columnProjection;
        }

        public S cacheBlocks(boolean cacheBlocks) {
            this.cacheBlocks = cacheBlocks;
            return (S)this;
        }

        public S isFaultTolerant(boolean isFaultTolerant) {
            this.isFaultTolerant = isFaultTolerant;
            return (S)this;
        }

        @Override
        public void configure() throws IOException {
            this.job.setInputFormatClass(KuduTableInputFormat.class);
            Configuration conf = this.job.getConfiguration();
            conf.set("kudu.mapreduce.master.address", this.masterAddresses);
            conf.set("kudu.mapreduce.input.table", this.table);
            conf.setLong("kudu.mapreduce.operation.timeout.ms", this.operationTimeoutMs);
            conf.setBoolean("kudu.mapreduce.input.scan.cache.blocks", this.cacheBlocks);
            conf.setBoolean("kudu.mapreduce.input.fault.tolerant.scan", this.isFaultTolerant);
            if (this.columnProjection != null) {
                conf.set("kudu.mapreduce.column.projection", this.columnProjection);
            }
            conf.set("kudu.mapreduce.encoded.predicates", KuduTableMapReduceUtil.base64EncodePredicates(this.predicates));
            if (this.addDependencies) {
                KuduTableMapReduceUtil.addDependencyJars(this.job);
            }
            this.addCredentialsToJob(this.masterAddresses, this.operationTimeoutMs);
        }
    }

    private static abstract class AbstractTableOutputFormatConfigurator<S extends AbstractTableOutputFormatConfigurator<? super S>>
    extends AbstractMapReduceConfigurator<S> {
        protected String masterAddresses;
        protected long operationTimeoutMs = 30000L;

        private AbstractTableOutputFormatConfigurator(Job job, String table) {
            super(job, table);
        }

        @Override
        public void configure() throws IOException {
            this.job.setOutputFormatClass(KuduTableOutputFormat.class);
            this.job.setOutputKeyClass(NullWritable.class);
            this.job.setOutputValueClass(Operation.class);
            Configuration conf = this.job.getConfiguration();
            conf.set("kudu.mapreduce.master.addresses", this.masterAddresses);
            conf.set("kudu.mapreduce.output.table", this.table);
            conf.setLong("kudu.mapreduce.operation.timeout.ms", this.operationTimeoutMs);
            if (this.addDependencies) {
                KuduTableMapReduceUtil.addDependencyJars(this.job);
            }
            this.addCredentialsToJob(this.masterAddresses, this.operationTimeoutMs);
        }
    }

    private static abstract class AbstractMapReduceConfigurator<S> {
        protected final Job job;
        protected final String table;
        protected boolean addDependencies = true;

        private AbstractMapReduceConfigurator(Job job, String table) {
            this.job = job;
            this.table = table;
        }

        public S addDependencies(boolean addDependencies) {
            this.addDependencies = addDependencies;
            return (S)this;
        }

        protected void addCredentialsToJob(String masterAddresses, long operationTimeoutMs) throws KuduException {
            try (KuduClient client = new KuduClient.KuduClientBuilder(masterAddresses).defaultOperationTimeoutMs(operationTimeoutMs).build();){
                KuduTableMapReduceUtil.addCredentialsToJob(client, this.job);
            }
        }

        public abstract void configure() throws IOException;
    }
}

