/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Iterator;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpcResponse;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.Status;
import org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowResultIterator
extends KuduRpcResponse
implements Iterator<RowResult>,
Iterable<RowResult> {
    private static final RowResultIterator EMPTY = new RowResultIterator(0L, null, null, 0, null, null);
    private final Schema schema;
    private final Slice bs;
    private final Slice indirectBs;
    private final int numRows;
    private final RowResult rowResult;
    private int currentRow = 0;

    private RowResultIterator(long ellapsedMillis, String tsUUID, Schema schema, int numRows, Slice bs, Slice indirectBs) {
        super(ellapsedMillis, tsUUID);
        this.schema = schema;
        this.bs = bs;
        this.indirectBs = indirectBs;
        this.numRows = numRows;
        this.rowResult = numRows == 0 ? null : new RowResult(this.schema, this.bs, this.indirectBs);
    }

    static RowResultIterator makeRowResultIterator(long ellapsedMillis, String tsUUID, Schema schema, WireProtocol.RowwiseRowBlockPB data, CallResponse callResponse) throws KuduException {
        int rowSize;
        if (data == null || data.getNumRows() == 0) {
            return new RowResultIterator(ellapsedMillis, tsUUID, schema, 0, null, null);
        }
        Slice bs = callResponse.getSidecar(data.getRowsSidecar());
        Slice indirectBs = callResponse.getSidecar(data.getIndirectDataSidecar());
        int numRows = data.getNumRows();
        int expectedSize = numRows * (rowSize = schema.getRowSize());
        if (expectedSize != bs.length()) {
            Status statusIllegalState = Status.IllegalState("RowResult block has " + bs.length() + " bytes of data but expected " + expectedSize + " for " + numRows + " rows");
            throw new NonRecoverableException(statusIllegalState);
        }
        return new RowResultIterator(ellapsedMillis, tsUUID, schema, numRows, bs, indirectBs);
    }

    public static RowResultIterator empty() {
        return EMPTY;
    }

    @Override
    public boolean hasNext() {
        return this.currentRow < this.numRows;
    }

    @Override
    public RowResult next() {
        this.rowResult.advancePointer();
        ++this.currentRow;
        return this.rowResult;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getNumRows() {
        return this.numRows;
    }

    public String toString() {
        return "RowResultIterator for " + this.numRows + " rows";
    }

    @Override
    public Iterator<RowResult> iterator() {
        return this;
    }
}

