/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Common;
import org.apache.kudu.client.AbstractKuduScannerBuilder;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Client;
import org.apache.kudu.client.KeyEncoder;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.PartitionPruner;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class KuduScanToken
implements Comparable<KuduScanToken> {
    private final LocatedTablet tablet;
    private final Client.ScanTokenPB message;

    private KuduScanToken(LocatedTablet tablet, Client.ScanTokenPB message) {
        this.tablet = tablet;
        this.message = message;
    }

    public LocatedTablet getTablet() {
        return this.tablet;
    }

    public KuduScanner intoScanner(KuduClient client) throws Exception {
        return KuduScanToken.pbIntoScanner(this.message, client);
    }

    public byte[] serialize() throws IOException {
        return KuduScanToken.serialize(this.message);
    }

    @VisibleForTesting
    static byte[] serialize(Client.ScanTokenPB message) throws IOException {
        byte[] buf = new byte[message.getSerializedSize()];
        CodedOutputStream cos = CodedOutputStream.newInstance(buf);
        message.writeTo(cos);
        cos.flush();
        return buf;
    }

    public static KuduScanner deserializeIntoScanner(byte[] buf, KuduClient client) throws IOException {
        return KuduScanToken.pbIntoScanner(Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf)), client);
    }

    public static String stringifySerializedToken(byte[] buf, KuduClient client) throws IOException {
        Client.ScanTokenPB token = Client.ScanTokenPB.parseFrom(CodedInputStream.newInstance(buf));
        KuduTable table = client.openTable(token.getTableName());
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ScanToken").add("table", token.getTableName());
        if (token.hasLowerBoundPrimaryKey() && !token.getLowerBoundPrimaryKey().isEmpty()) {
            helper.add("lower-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getLowerBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        if (token.hasUpperBoundPrimaryKey() && !token.getUpperBoundPrimaryKey().isEmpty()) {
            helper.add("upper-bound-primary-key", KeyEncoder.decodePrimaryKey(table.getSchema(), token.getUpperBoundPrimaryKey().toByteArray()).stringifyRowKey());
        }
        helper.addValue(KeyEncoder.formatPartitionKeyRange(table.getSchema(), table.getPartitionSchema(), token.getLowerBoundPartitionKey().toByteArray(), token.getUpperBoundPartitionKey().toByteArray()));
        return helper.toString();
    }

    private static KuduScanner pbIntoScanner(Client.ScanTokenPB message, KuduClient client) throws KuduException {
        Preconditions.checkArgument(!message.getFeatureFlagsList().contains(Client.ScanTokenPB.Feature.Unknown), "Scan token requires an unsupported feature. This Kudu client must be updated.");
        KuduTable table = client.openTable(message.getTableName());
        KuduScanner.KuduScannerBuilder builder = client.newScannerBuilder(table);
        ArrayList<Integer> columns = new ArrayList<Integer>(message.getProjectedColumnsCount());
        for (Common.ColumnSchemaPB column : message.getProjectedColumnsList()) {
            int columnIdx = table.getSchema().getColumnIndex(column.getName());
            ColumnSchema schema = table.getSchema().getColumnByIndex(columnIdx);
            if (column.getType() != schema.getType().getDataType(schema.getTypeAttributes())) {
                throw new IllegalStateException(String.format("invalid type %s for column '%s' in scan token, expected: %s", column.getType().name(), column.getName(), schema.getType().name()));
            }
            if (column.getIsNullable() != schema.isNullable()) {
                throw new IllegalStateException(String.format("invalid nullability for column '%s' in scan token, expected: %s", column.getName(), column.getIsNullable() ? "NULLABLE" : "NOT NULL"));
            }
            columns.add(columnIdx);
        }
        builder.setProjectedColumnIndexes(columns);
        for (Common.ColumnPredicatePB pred : message.getColumnPredicatesList()) {
            builder.addPredicate(KuduPredicate.fromPB(table.getSchema(), pred));
        }
        if (message.hasLowerBoundPrimaryKey()) {
            builder.lowerBoundRaw(message.getLowerBoundPrimaryKey().toByteArray());
        }
        if (message.hasUpperBoundPrimaryKey()) {
            builder.exclusiveUpperBoundRaw(message.getUpperBoundPrimaryKey().toByteArray());
        }
        if (message.hasLowerBoundPartitionKey()) {
            builder.lowerBoundPartitionKeyRaw(message.getLowerBoundPartitionKey().toByteArray());
        }
        if (message.hasUpperBoundPartitionKey()) {
            builder.exclusiveUpperBoundPartitionKeyRaw(message.getUpperBoundPartitionKey().toByteArray());
        }
        if (message.hasLimit()) {
            builder.limit(message.getLimit());
        }
        if (message.hasReadMode()) {
            switch (message.getReadMode()) {
                case READ_AT_SNAPSHOT: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT);
                    if (!message.hasSnapTimestamp()) break;
                    builder.snapshotTimestampRaw(message.getSnapTimestamp());
                    break;
                }
                case READ_LATEST: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_LATEST);
                    break;
                }
                case READ_YOUR_WRITES: {
                    builder.readMode(AsyncKuduScanner.ReadMode.READ_YOUR_WRITES);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown read mode");
                }
            }
        }
        if (message.hasReplicaSelection()) {
            switch (message.getReplicaSelection()) {
                case LEADER_ONLY: {
                    builder.replicaSelection(ReplicaSelection.LEADER_ONLY);
                    break;
                }
                case CLOSEST_REPLICA: {
                    builder.replicaSelection(ReplicaSelection.CLOSEST_REPLICA);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown replica selection policy");
                }
            }
        }
        if (message.hasPropagatedTimestamp() && message.getPropagatedTimestamp() != -1L) {
            client.updateLastPropagatedTimestamp(message.getPropagatedTimestamp());
        }
        if (message.hasCacheBlocks()) {
            builder.cacheBlocks(message.getCacheBlocks());
        }
        if (message.hasFaultTolerant()) {
            builder.setFaultTolerant(message.getFaultTolerant());
        }
        if (message.hasBatchSizeBytes()) {
            builder.batchSizeBytes(message.getBatchSizeBytes());
        }
        return builder.build();
    }

    @Override
    public int compareTo(KuduScanToken other) {
        if (!this.message.getTableName().equals(other.message.getTableName())) {
            throw new IllegalArgumentException("Scan tokens from different tables may not be compared");
        }
        return this.tablet.getPartition().compareTo(other.getTablet().getPartition());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static class KuduScanTokenBuilder
    extends AbstractKuduScannerBuilder<KuduScanTokenBuilder, List<KuduScanToken>> {
        private long timeout;

        KuduScanTokenBuilder(AsyncKuduClient client, KuduTable table) {
            super(client, table);
            this.timeout = client.getDefaultOperationTimeoutMs();
        }

        public KuduScanTokenBuilder setTimeout(long timeoutMs) {
            this.timeout = timeoutMs;
            return this;
        }

        @Override
        public List<KuduScanToken> build() {
            ColumnSchema columnSchema;
            if (this.lowerBoundPartitionKey.length != 0 || this.upperBoundPartitionKey.length != 0) {
                throw new IllegalArgumentException("Partition key bounds may not be set on KuduScanTokenBuilder");
            }
            for (Object predicate : this.predicates.values()) {
                if (((KuduPredicate)predicate).getType() != KuduPredicate.PredicateType.NONE) continue;
                return ImmutableList.of();
            }
            Client.ScanTokenPB.Builder proto = Client.ScanTokenPB.newBuilder();
            proto.setTableName(this.table.getName());
            if (this.projectedColumnNames != null) {
                for (String columnName : this.projectedColumnNames) {
                    columnSchema = this.table.getSchema().getColumn(columnName);
                    Preconditions.checkArgument(columnSchema != null, "unknown column i%s", (Object)columnName);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), columnSchema);
                }
            } else if (this.projectedColumnIndexes != null) {
                Object predicate;
                predicate = this.projectedColumnIndexes.iterator();
                while (predicate.hasNext()) {
                    int columnIdx = (Integer)predicate.next();
                    columnSchema = this.table.getSchema().getColumnByIndex(columnIdx);
                    Preconditions.checkArgument(columnSchema != null, "unknown column index %s", columnIdx);
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), columnSchema);
                }
            } else {
                for (ColumnSchema column : this.table.getSchema().getColumns()) {
                    ProtobufHelper.columnToPb(proto.addProjectedColumnsBuilder(), column);
                }
            }
            for (KuduPredicate predicate : this.predicates.values()) {
                proto.addColumnPredicates(predicate.toPB());
            }
            if (this.lowerBoundPrimaryKey.length > 0) {
                proto.setLowerBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.lowerBoundPrimaryKey));
            }
            if (this.upperBoundPrimaryKey.length > 0) {
                proto.setUpperBoundPrimaryKey(UnsafeByteOperations.unsafeWrap(this.upperBoundPrimaryKey));
            }
            proto.setLimit(this.limit);
            proto.setReadMode(this.readMode.pbVersion());
            if (this.replicaSelection == ReplicaSelection.LEADER_ONLY) {
                proto.setReplicaSelection(Common.ReplicaSelection.LEADER_ONLY);
            } else if (this.replicaSelection == ReplicaSelection.CLOSEST_REPLICA) {
                proto.setReplicaSelection(Common.ReplicaSelection.CLOSEST_REPLICA);
            }
            if (this.table.getAsyncClient().getLastPropagatedTimestamp() != -1L) {
                proto.setPropagatedTimestamp(this.client.getLastPropagatedTimestamp());
            }
            if (this.readMode == AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT && this.htTimestamp != -1L) {
                proto.setSnapTimestamp(this.htTimestamp);
            }
            proto.setCacheBlocks(this.cacheBlocks);
            proto.setFaultTolerant(this.isFaultTolerant);
            proto.setBatchSizeBytes(this.batchSizeBytes);
            try {
                PartitionPruner pruner = PartitionPruner.create(this);
                ArrayList<LocatedTablet> tablets = new ArrayList<LocatedTablet>();
                while (pruner.hasMorePartitionKeyRanges()) {
                    Pair<byte[], byte[]> partitionRange = pruner.nextPartitionKeyRange();
                    List<LocatedTablet> newTablets = this.table.getTabletsLocations(partitionRange.getFirst().length == 0 ? null : partitionRange.getFirst(), partitionRange.getSecond().length == 0 ? null : partitionRange.getSecond(), this.timeout);
                    if (newTablets.isEmpty()) {
                        pruner.removePartitionKeyRange(partitionRange.getSecond());
                    } else {
                        pruner.removePartitionKeyRange(newTablets.get(newTablets.size() - 1).getPartition().getPartitionKeyEnd());
                    }
                    tablets.addAll(newTablets);
                }
                ArrayList<KuduScanToken> tokens = new ArrayList<KuduScanToken>(tablets.size());
                for (LocatedTablet tablet : tablets) {
                    Client.ScanTokenPB.Builder builder = proto.clone();
                    builder.setLowerBoundPartitionKey(UnsafeByteOperations.unsafeWrap(tablet.getPartition().getPartitionKeyStart()));
                    builder.setUpperBoundPartitionKey(UnsafeByteOperations.unsafeWrap(tablet.getPartition().getPartitionKeyEnd()));
                    tokens.add(new KuduScanToken(tablet, builder.build()));
                }
                return tokens;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

