/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class GetTableLocationsRequest
extends KuduRpc<Master.GetTableLocationsResponsePB> {
    private final byte[] startPartitionKey;
    private final byte[] endKey;
    private final String tableId;
    private final int maxReturnedLocations;

    GetTableLocationsRequest(KuduTable table, byte[] startPartitionKey, byte[] endPartitionKey, String tableId, int maxReturnedLocations) {
        super(table);
        if (startPartitionKey != null && endPartitionKey != null && Bytes.memcmp(startPartitionKey, endPartitionKey) > 0) {
            throw new IllegalArgumentException("The start partition key must be smaller or equal to the end partition key");
        }
        this.startPartitionKey = startPartitionKey;
        this.endKey = endPartitionKey;
        this.tableId = tableId;
        this.maxReturnedLocations = maxReturnedLocations;
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return "GetTableLocations";
    }

    @Override
    Pair<Master.GetTableLocationsResponsePB, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.GetTableLocationsResponsePB.Builder builder = Master.GetTableLocationsResponsePB.newBuilder();
        GetTableLocationsRequest.readProtobuf(callResponse.getPBMessage(), builder);
        Master.GetTableLocationsResponsePB resp = builder.build();
        return new Pair<Master.GetTableLocationsResponsePB, Object>(resp, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Message createRequestPB() {
        Master.GetTableLocationsRequestPB.Builder builder = Master.GetTableLocationsRequestPB.newBuilder();
        builder.setTable(Master.TableIdentifierPB.newBuilder().setTableId(ByteString.copyFromUtf8(this.tableId)));
        if (this.startPartitionKey != null) {
            builder.setPartitionKeyStart(UnsafeByteOperations.unsafeWrap(this.startPartitionKey));
        }
        if (this.endKey != null) {
            builder.setPartitionKeyEnd(UnsafeByteOperations.unsafeWrap(this.endKey));
        }
        builder.setMaxReturnedLocations(this.maxReturnedLocations);
        return builder.build();
    }
}

