/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.net.InetAddress;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.util.NetUtil;

@InterfaceAudience.Private
public class ServerInfo {
    private final String uuid;
    private final HostAndPort hostPort;
    private final InetAddress resolvedAddr;
    private final boolean local;

    public ServerInfo(String uuid, HostAndPort hostPort, InetAddress resolvedAddr) {
        this.uuid = uuid;
        this.hostPort = hostPort;
        this.resolvedAddr = resolvedAddr;
        this.local = NetUtil.isLocalAddress(resolvedAddr);
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getHostname() {
        return this.hostPort.getHostText();
    }

    public int getPort() {
        return this.hostPort.getPort();
    }

    public boolean isLocal() {
        return this.local;
    }

    public InetAddress getResolvedAddress() {
        return this.resolvedAddr;
    }
}

