/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.BitSet;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.util.Slice;
import org.apache.kudu.util.TimestampUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class RowwiseRowResult
extends RowResult {
    private final Slice rowData;
    private final Slice indirectData;
    private final int rowSize;
    private final int[] columnOffsets;
    private int offset;
    private BitSet nullsBitSet;

    RowwiseRowResult(Schema schema, Slice rowData, Slice indirectData, int rowIndex) {
        super(schema, rowIndex);
        int currentOffset;
        this.rowData = rowData;
        this.indirectData = indirectData;
        this.rowSize = this.schema.getRowSize();
        int columnOffsetsSize = schema.getColumnCount();
        if (schema.hasNullableColumns()) {
            ++columnOffsetsSize;
        }
        this.columnOffsets = new int[columnOffsetsSize];
        if (columnOffsetsSize == 0) {
            return;
        }
        this.columnOffsets[0] = currentOffset = 0;
        for (int i = 1; i < columnOffsetsSize; ++i) {
            ColumnSchema column = schema.getColumnByIndex(i - 1);
            int previousSize = column.getTypeSize();
            this.columnOffsets[i] = previousSize + currentOffset;
            currentOffset += previousSize;
        }
        this.advancePointerTo(rowIndex);
    }

    @Override
    void advancePointerTo(int rowIndex) {
        super.advancePointerTo(rowIndex);
        this.offset = this.rowSize * this.index;
        if (this.schema.hasNullableColumns() && this.index != -1) {
            this.nullsBitSet = Bytes.toBitSet(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(this.schema.getColumnCount()), this.schema.getColumnCount());
        }
    }

    int getCurrentRowDataOffsetForColumn(int columnIndex) {
        return this.offset + this.columnOffsets[columnIndex];
    }

    @Override
    public int getInt(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT32, Type.DATE);
        return Bytes.getInt(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public short getShort(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT16);
        return Bytes.getShort(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BOOL);
        byte b = Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
        return b == 1;
    }

    @Override
    public byte getByte(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT8);
        return Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public long getLong(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT64, Type.UNIXTIME_MICROS);
        return Bytes.getLong(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.FLOAT);
        return Bytes.getFloat(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DOUBLE);
        return Bytes.getDouble(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public BigDecimal getDecimal(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DECIMAL);
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        return Bytes.getDecimal(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex), typeAttributes.getPrecision(), typeAttributes.getScale());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.UNIXTIME_MICROS);
        long micros = this.getLong(columnIndex);
        return TimestampUtil.microsToTimestamp(micros);
    }

    @Override
    public String getVarLengthData(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.STRING, Type.VARCHAR);
        long offset = this.getOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return Bytes.getString(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    @Override
    public byte[] getBinaryCopy(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        long offset = this.getOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        byte[] ret = new byte[(int)length];
        System.arraycopy(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, ret, 0, (int)length);
        return ret;
    }

    @Override
    public ByteBuffer getBinary(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BINARY);
        long offset = this.getOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return ByteBuffer.wrap(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    long getOffset(int columnIndex) {
        return Bytes.getLong(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    @Override
    public boolean isNull(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (this.nullsBitSet == null) {
            return false;
        }
        return this.schema.getColumnByIndex(columnIndex).isNullable() && this.nullsBitSet.get(columnIndex);
    }

    public String toString() {
        return "RowResult(Rowwise) index: " + this.index + ", size: " + this.rowSize;
    }
}

