/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.cache;

import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.shaded.com.google.common.cache.Cache;
import org.apache.kudu.shaded.com.google.common.cache.LoadingCache;

@NonNullApi
@NonNullFields
public class GuavaCacheMetrics
extends CacheMeterBinder {
    private final Cache<?, ?> cache;

    public static <C extends Cache<?, ?>> C monitor(MeterRegistry registry, C cache, String cacheName, String ... tags) {
        return GuavaCacheMetrics.monitor(registry, cache, cacheName, Tags.of(tags));
    }

    public static <C extends Cache<?, ?>> C monitor(MeterRegistry registry, C cache, String cacheName, Iterable<Tag> tags) {
        new GuavaCacheMetrics(cache, cacheName, tags).bindTo(registry);
        return cache;
    }

    public GuavaCacheMetrics(Cache<?, ?> cache, String cacheName, Iterable<Tag> tags) {
        super(cache, cacheName, tags);
        this.cache = cache;
    }

    @Override
    protected Long size() {
        return this.cache.size();
    }

    @Override
    protected long hitCount() {
        return this.cache.stats().hitCount();
    }

    @Override
    protected Long missCount() {
        return this.cache.stats().missCount();
    }

    @Override
    protected Long evictionCount() {
        return this.cache.stats().evictionCount();
    }

    @Override
    protected long putCount() {
        return this.cache.stats().loadCount();
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
        if (this.cache instanceof LoadingCache) {
            TimeGauge.builder("cache.load.duration", this.cache, TimeUnit.NANOSECONDS, c -> c.stats().totalLoadTime()).tags(this.getTagsWithCacheName()).description("The time the cache has spent loading new values").register(registry);
            FunctionCounter.builder("cache.load", this.cache, c -> c.stats().loadSuccessCount()).tags(this.getTagsWithCacheName()).tags("result", "success").description("The number of times cache lookup methods have successfully loaded a new value").register(registry);
            FunctionCounter.builder("cache.load", this.cache, c -> c.stats().loadExceptionCount()).tags(this.getTagsWithCacheName()).tags("result", "failure").description("The number of times cache lookup methods threw an exception while loading a new value").register(registry);
        }
    }
}

