/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.BitSet;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.util.Slice;
import org.apache.kudu.util.TimestampUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowResult {
    private static final int INDEX_RESET_LOCATION = -1;
    private final Schema schema;
    private final Slice indirectData;
    private final int rowSize;
    private final int[] columnOffsets;
    private Slice rowData;
    private int index = -1;
    private int offset;
    private BitSet nullsBitSet;

    RowResult(Schema schema, Slice rowData, Slice indirectData, int rowIndex) {
        int currentOffset;
        this.schema = schema;
        this.rowData = rowData;
        this.indirectData = indirectData;
        this.rowSize = this.schema.getRowSize();
        int columnOffsetsSize = schema.getColumnCount();
        if (schema.hasNullableColumns()) {
            ++columnOffsetsSize;
        }
        this.columnOffsets = new int[columnOffsetsSize];
        if (columnOffsetsSize == 0) {
            return;
        }
        this.columnOffsets[0] = currentOffset = 0;
        for (int i = 1; i < columnOffsetsSize; ++i) {
            ColumnSchema column = schema.getColumnByIndex(i - 1);
            int previousSize = column.getTypeSize();
            this.columnOffsets[i] = previousSize + currentOffset;
            currentOffset += previousSize;
        }
        this.advancePointerTo(rowIndex);
    }

    void resetPointer() {
        this.advancePointerTo(-1);
    }

    void advancePointerTo(int rowIndex) {
        this.index = rowIndex;
        this.offset = this.rowSize * this.index;
        if (this.schema.hasNullableColumns() && this.index != -1) {
            this.nullsBitSet = Bytes.toBitSet(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(this.schema.getColumnCount()), this.schema.getColumnCount());
        }
    }

    int getCurrentRowDataOffsetForColumn(int columnIndex) {
        return this.offset + this.columnOffsets[columnIndex];
    }

    public int getInt(String columnName) {
        return this.getInt(this.schema.getColumnIndex(columnName));
    }

    public int getInt(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT32);
        return Bytes.getInt(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public short getShort(String columnName) {
        return this.getShort(this.schema.getColumnIndex(columnName));
    }

    public short getShort(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT16);
        return Bytes.getShort(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.schema.getColumnIndex(columnName));
    }

    public boolean getBoolean(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BOOL);
        byte b = Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
        return b == 1;
    }

    public byte getByte(String columnName) {
        return this.getByte(this.schema.getColumnIndex(columnName));
    }

    public byte getByte(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT8);
        return Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public long getLong(String columnName) {
        return this.getLong(this.schema.getColumnIndex(columnName));
    }

    public long getLong(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT64, Type.UNIXTIME_MICROS);
        return this.getLongOrOffset(columnIndex);
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.schema.getColumnIndex(columnName));
    }

    public float getFloat(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.FLOAT);
        return Bytes.getFloat(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.schema.getColumnIndex(columnName));
    }

    public double getDouble(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DOUBLE);
        return Bytes.getDouble(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public BigDecimal getDecimal(String columnName) {
        return this.getDecimal(this.schema.getColumnIndex(columnName));
    }

    public BigDecimal getDecimal(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DECIMAL);
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        return Bytes.getDecimal(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex), typeAttributes.getPrecision(), typeAttributes.getScale());
    }

    public Timestamp getTimestamp(String columnName) {
        return this.getTimestamp(this.schema.getColumnIndex(columnName));
    }

    public Timestamp getTimestamp(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.UNIXTIME_MICROS);
        long micros = this.getLongOrOffset(columnIndex);
        return TimestampUtil.microsToTimestamp(micros);
    }

    public Schema getColumnProjection() {
        return this.schema;
    }

    public String getString(String columnName) {
        return this.getString(this.schema.getColumnIndex(columnName));
    }

    public String getString(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.STRING);
        long offset = this.getLongOrOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return Bytes.getString(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    public byte[] getBinaryCopy(String columnName) {
        return this.getBinaryCopy(this.schema.getColumnIndex(columnName));
    }

    public byte[] getBinaryCopy(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        long offset = this.getLongOrOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        byte[] ret = new byte[(int)length];
        System.arraycopy(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, ret, 0, (int)length);
        return ret;
    }

    public ByteBuffer getBinary(String columnName) {
        return this.getBinary(this.schema.getColumnIndex(columnName));
    }

    public ByteBuffer getBinary(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BINARY);
        long offset = this.getLongOrOffset(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return ByteBuffer.wrap(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    long getLongOrOffset(int columnIndex) {
        return Bytes.getLong(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.schema.getColumnIndex(columnName));
    }

    public boolean isNull(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (this.nullsBitSet == null) {
            return false;
        }
        return this.schema.getColumnByIndex(columnIndex).isNullable() && this.nullsBitSet.get(columnIndex);
    }

    public Object getObject(String columnName) {
        return this.getObject(this.schema.getColumnIndex(columnName));
    }

    public Object getObject(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (this.isNull(columnIndex)) {
            return null;
        }
        Type type = this.schema.getColumnByIndex(columnIndex).getType();
        switch (type) {
            case BOOL: {
                return this.getBoolean(columnIndex);
            }
            case INT8: {
                return this.getByte(columnIndex);
            }
            case INT16: {
                return this.getShort(columnIndex);
            }
            case INT32: {
                return this.getInt(columnIndex);
            }
            case INT64: {
                return this.getLong(columnIndex);
            }
            case UNIXTIME_MICROS: {
                return this.getTimestamp(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(columnIndex));
            }
            case DOUBLE: {
                return this.getDouble(columnIndex);
            }
            case STRING: {
                return this.getString(columnIndex);
            }
            case BINARY: {
                return this.getBinaryCopy(columnIndex);
            }
            case DECIMAL: {
                return this.getDecimal(columnIndex);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + (Object)((Object)type));
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean hasIsDeleted() {
        return this.schema.hasIsDeleted();
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public boolean isDeleted() {
        return this.getBoolean(this.schema.getIsDeletedIndex());
    }

    public Type getColumnType(String columnName) {
        return this.schema.getColumn(columnName).getType();
    }

    public Type getColumnType(int columnIndex) {
        return this.schema.getColumnByIndex(columnIndex).getType();
    }

    public Schema getSchema() {
        return this.schema;
    }

    private void checkValidColumn(int columnIndex) {
        if (columnIndex >= this.schema.getColumnCount()) {
            throw new IndexOutOfBoundsException("Requested column is out of range, " + columnIndex + " out of " + this.schema.getColumnCount());
        }
    }

    private void checkNull(int columnIndex) {
        if (!this.schema.hasNullableColumns()) {
            return;
        }
        if (this.isNull(columnIndex)) {
            ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
            throw new IllegalArgumentException("The requested column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is null");
        }
    }

    private void checkType(int columnIndex, Type ... types) {
        ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
        Type columnType = columnSchema.getType();
        for (Type type : types) {
            if (!columnType.equals((Object)type)) continue;
            return;
        }
        throw new IllegalArgumentException("Column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is of type " + columnType.getName() + " but was requested as a type " + Arrays.toString((Object[])types));
    }

    public String toString() {
        return "RowResult index: " + this.index + ", size: " + this.rowSize;
    }

    public String rowToString() {
        StringBuilder buf = new StringBuilder();
        block13: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            ColumnSchema col = this.schema.getColumnByIndex(i);
            if (i != 0) {
                buf.append(", ");
            }
            Type type = col.getType();
            buf.append(type.name());
            buf.append(" ").append(col.getName());
            if (col.getTypeAttributes() != null) {
                buf.append(col.getTypeAttributes().toStringForType(type));
            }
            buf.append("=");
            if (this.isNull(i)) {
                buf.append("NULL");
                continue;
            }
            switch (col.getType()) {
                case INT8: {
                    buf.append(this.getByte(i));
                    continue block13;
                }
                case INT16: {
                    buf.append(this.getShort(i));
                    continue block13;
                }
                case INT32: {
                    buf.append(this.getInt(i));
                    continue block13;
                }
                case INT64: {
                    buf.append(this.getLong(i));
                    continue block13;
                }
                case UNIXTIME_MICROS: {
                    buf.append(TimestampUtil.timestampToString(this.getTimestamp(i)));
                    continue block13;
                }
                case STRING: {
                    buf.append(this.getString(i));
                    continue block13;
                }
                case BINARY: {
                    buf.append(Bytes.pretty(this.getBinaryCopy(i)));
                    continue block13;
                }
                case FLOAT: {
                    buf.append(this.getFloat(i));
                    continue block13;
                }
                case DOUBLE: {
                    buf.append(this.getDouble(i));
                    continue block13;
                }
                case DECIMAL: {
                    buf.append(this.getDecimal(i));
                    continue block13;
                }
                case BOOL: {
                    buf.append(this.getBoolean(i));
                    continue block13;
                }
                default: {
                    buf.append("<unknown type!>");
                }
            }
        }
        return buf.toString();
    }

    public String toStringLongFormat() {
        StringBuilder buf = new StringBuilder(this.rowSize);
        buf.append(this.toString());
        buf.append("{");
        buf.append(this.rowToString());
        buf.append("}");
        return buf.toString();
    }
}

