/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.provider.federation.jwt.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.text.ParseException;
import java.util.Base64;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.provider.federation.jwt.JWTMessages;
import org.apache.knox.gateway.provider.federation.jwt.filter.AbstractJWTFilter;
import org.apache.knox.gateway.security.PrimaryPrincipal;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.security.token.impl.JWT;
import org.apache.knox.gateway.services.security.token.impl.JWTToken;
import org.apache.knox.gateway.util.AuthFilterUtils;
import org.apache.knox.gateway.util.CertificateUtils;

public class JWTFederationFilter
extends AbstractJWTFilter {
    private static final JWTMessages LOGGER = (JWTMessages)MessagesFactory.get(JWTMessages.class);
    public static final String JWT_UNAUTHENTICATED_PATHS_PARAM = "jwt.unauthenticated.path.list";
    public static final String KNOX_TOKEN_AUDIENCES = "knox.token.audiences";
    public static final String TOKEN_VERIFICATION_PEM = "knox.token.verification.pem";
    public static final String KNOX_TOKEN_QUERY_PARAM_NAME = "knox.token.query.param.name";
    public static final String TOKEN_PRINCIPAL_CLAIM = "knox.token.principal.claim";
    public static final String JWKS_URL = "knox.token.jwks.url";
    public static final String BEARER = "Bearer ";
    public static final String BASIC = "Basic";
    public static final String TOKEN = "Token";
    public static final String PASSCODE = "Passcode";
    private String paramName;
    private Set<String> unAuthenticatedPaths = new HashSet<String>(20);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String verificationPEM;
        String oidcPrincipalclaim;
        String oidcjwksurl;
        String queryParamName;
        super.init(filterConfig);
        String expectedAudiences = filterConfig.getInitParameter(KNOX_TOKEN_AUDIENCES);
        if (expectedAudiences != null) {
            this.audiences = this.parseExpectedAudiences(expectedAudiences);
        }
        if ((queryParamName = filterConfig.getInitParameter(KNOX_TOKEN_QUERY_PARAM_NAME)) != null) {
            this.paramName = queryParamName;
        }
        if ((oidcjwksurl = filterConfig.getInitParameter(JWKS_URL)) != null) {
            this.expectedJWKSUrl = oidcjwksurl;
        }
        if ((oidcPrincipalclaim = filterConfig.getInitParameter(TOKEN_PRINCIPAL_CLAIM)) != null) {
            this.expectedPrincipalClaim = oidcPrincipalclaim;
        }
        if ((verificationPEM = filterConfig.getInitParameter(TOKEN_VERIFICATION_PEM)) != null) {
            this.publicKey = CertificateUtils.parseRSAPublicKey((String)verificationPEM);
        }
        String unAuthPathString = filterConfig.getInitParameter(JWT_UNAUTHENTICATED_PATHS_PARAM);
        AuthFilterUtils.addUnauthPaths(this.unAuthenticatedPaths, (String)unAuthPathString, (String)"/knoxtoken/api/v1/jwks.json");
        this.configureExpectedParameters(filterConfig);
    }

    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (AuthFilterUtils.doesRequestContainUnauthPath(this.unAuthenticatedPaths, (ServletRequest)request)) {
            this.continueWithAnonymousSubject(request, response, chain);
            return;
        }
        Pair<TokenType, String> wireToken = this.getWireToken(request);
        if (wireToken != null && wireToken.getLeft() != null && wireToken.getRight() != null) {
            TokenType tokenType = (TokenType)((Object)wireToken.getLeft());
            String tokenValue = (String)wireToken.getRight();
            if (TokenType.JWT.equals((Object)tokenType)) {
                try {
                    JWTToken token = new JWTToken(tokenValue);
                    if (this.validateToken((HttpServletRequest)request, (HttpServletResponse)response, chain, (JWT)token)) {
                        Subject subject = this.createSubjectFromToken((JWT)token);
                        this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                    }
                }
                catch (ParseException | UnknownTokenException ex) {
                    ((HttpServletResponse)response).sendError(401);
                }
            } else if (TokenType.Passcode.equals((Object)tokenType)) {
                String tokenId = null;
                String passcode = null;
                try {
                    String[] base64DecodedTokenIdAndPasscode = this.decodeBase64(tokenValue).split("::");
                    tokenId = this.decodeBase64(base64DecodedTokenIdAndPasscode[0]);
                    passcode = this.decodeBase64(base64DecodedTokenIdAndPasscode[1]);
                }
                catch (Exception e) {
                    log.failedToParsePasscodeToken(e);
                    this.handleValidationError((HttpServletRequest)request, (HttpServletResponse)response, 401, "Error while parsing the received passcode token");
                }
                if (this.validateToken((HttpServletRequest)request, (HttpServletResponse)response, chain, tokenId, passcode)) {
                    try {
                        Subject subject = this.createSubjectFromTokenIdentifier(tokenId);
                        this.continueWithEstablishedSecurityContext(subject, (HttpServletRequest)request, (HttpServletResponse)response, chain);
                    }
                    catch (UnknownTokenException e) {
                        ((HttpServletResponse)response).sendError(401);
                    }
                }
            }
        } else {
            log.missingTokenFromHeader(wireToken);
            ((HttpServletResponse)response).sendError(401);
        }
    }

    private String decodeBase64(String toBeDecoded) {
        return new String(Base64.getDecoder().decode(toBeDecoded.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public Pair<TokenType, String> getWireToken(ServletRequest request) {
        Pair<TokenType, String> parsed = null;
        String token = null;
        String header = ((HttpServletRequest)request).getHeader("Authorization");
        if (header != null) {
            if (header.startsWith(BEARER)) {
                token = header.substring(BEARER.length());
                parsed = Pair.of((Object)((Object)TokenType.JWT), (Object)token);
            } else if (header.toLowerCase(Locale.ROOT).startsWith(BASIC.toLowerCase(Locale.ROOT))) {
                parsed = this.parseFromHTTPBasicCredentials(header);
            }
        }
        if (parsed == null && (token = request.getParameter(this.paramName)) != null) {
            parsed = Pair.of((Object)((Object)TokenType.JWT), (Object)token);
        }
        return parsed;
    }

    private Pair<TokenType, String> parseFromHTTPBasicCredentials(String header) {
        String passcode;
        Pair parsed = null;
        String base64Credentials = header.substring(BASIC.length()).trim();
        byte[] credDecoded = Base64.getDecoder().decode(base64Credentials);
        String credentials = new String(credDecoded, StandardCharsets.UTF_8);
        String[] values = credentials.split(":", 2);
        String username = values[0];
        String string = passcode = values[1].isEmpty() ? null : values[1];
        if (TOKEN.equalsIgnoreCase(username) || PASSCODE.equalsIgnoreCase(username)) {
            parsed = Pair.of((Object)((Object)(TOKEN.equalsIgnoreCase(username) ? TokenType.JWT : TokenType.Passcode)), (Object)passcode);
        }
        return parsed;
    }

    @Override
    protected void handleValidationError(HttpServletRequest request, HttpServletResponse response, int status, String error) throws IOException {
        if (error != null) {
            response.sendError(status, error);
        } else {
            response.sendError(status);
        }
    }

    private void continueWithAnonymousSubject(ServletRequest request, ServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            Subject sub = new Subject();
            sub.getPrincipals().add((Principal)new PrimaryPrincipal("anonymous"));
            LOGGER.unauthenticatedPathBypass(((HttpServletRequest)request).getRequestURI(), this.unAuthenticatedPaths.toString());
            this.continueWithEstablishedSecurityContext(sub, (HttpServletRequest)request, (HttpServletResponse)response, chain);
        }
        catch (Exception e) {
            LOGGER.unauthenticatedPathError(((HttpServletRequest)request).getRequestURI(), e.toString());
            throw e;
        }
    }

    public static enum TokenType {
        JWT,
        Passcode;

    }
}

