/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BTreeFactory;
import org.apache.directory.mavibot.btree.BTreeTypeEnum;
import org.apache.directory.mavibot.btree.KeyCursor;
import org.apache.directory.mavibot.btree.PersistedBTreeConfiguration;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.Tuple;
import org.apache.directory.mavibot.btree.exception.KeyNotFoundException;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.kerby.KrbIdentitySerializer;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.AbstractIdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotBackend
extends AbstractIdentityBackend {
    private static final String DATA_TREE = "kerby-data";
    private static final String DATABASE_NAME = "kerby-data.db";
    private static final Logger LOG = LoggerFactory.getLogger(MavibotBackend.class);
    private RecordManager rm;
    private BTree<String, KrbIdentity> database;

    public MavibotBackend(File location) throws Exception {
        String dbPath = location.getAbsolutePath();
        LOG.info("Initializing the mavibot backend");
        if (!location.exists() && !location.mkdirs()) {
            throw new KrbException("Can't create location file");
        }
        if (location.isDirectory()) {
            dbPath = dbPath + File.separator + DATABASE_NAME;
        }
        this.rm = new RecordManager(dbPath);
        if (this.rm.getManagedTrees().contains(DATA_TREE)) {
            this.database = this.rm.getManagedTree(DATA_TREE);
        } else {
            PersistedBTreeConfiguration config = new PersistedBTreeConfiguration();
            config.setAllowDuplicates(false);
            config.setBtreeType(BTreeTypeEnum.PERSISTED);
            config.setFilePath(dbPath);
            config.setKeySerializer((ElementSerializer)StringSerializer.INSTANCE);
            config.setName(DATA_TREE);
            config.setValueSerializer((ElementSerializer)KrbIdentitySerializer.INSTANCE);
            this.database = BTreeFactory.createPersistedBTree((PersistedBTreeConfiguration)config);
            this.rm.manage(this.database);
        }
    }

    protected Iterable<String> doGetIdentities() throws KrbException {
        ArrayList<String> keys = new ArrayList<String>();
        try (KeyCursor cursor = null;){
            cursor = this.database.browseKeys();
            while (cursor.hasNext()) {
                keys.add((String)cursor.next());
            }
        }
        return keys;
    }

    protected KrbIdentity doGetIdentity(String principalName) throws KrbException {
        try {
            return (KrbIdentity)this.database.get((Object)principalName);
        }
        catch (KeyNotFoundException e) {
            LOG.debug("Identity {} doesn't exist", (Object)principalName);
            return null;
        }
        catch (IOException e) {
            throw new KrbException("Failed to get the identity " + principalName);
        }
    }

    protected synchronized KrbIdentity doAddIdentity(KrbIdentity identity) throws KrbException {
        String p = identity.getPrincipalName();
        try {
            if (this.database.hasKey((Object)p)) {
                throw new KrbException("Identity already exists " + p);
            }
            return (KrbIdentity)this.database.insert((Object)p, (Object)identity);
        }
        catch (KeyNotFoundException e) {
            throw new KrbException("No such identity exists " + p);
        }
        catch (IOException e) {
            throw new KrbException("Failed to add the identity " + p);
        }
    }

    protected synchronized KrbIdentity doUpdateIdentity(KrbIdentity identity) throws KrbException {
        String p = identity.getPrincipalName();
        try {
            if (!this.database.hasKey((Object)p)) {
                throw new KrbException("No identity found with the principal " + p);
            }
            this.database.delete((Object)p);
            return (KrbIdentity)this.database.insert((Object)p, (Object)identity);
        }
        catch (Exception e) {
            throw new KrbException("Failed to update the identity " + p);
        }
    }

    protected void doDeleteIdentity(String principalName) throws KrbException {
        try {
            Tuple t = this.database.delete((Object)principalName);
            if (t == null) {
                throw new KrbException("Not existing, identity = " + principalName);
            }
        }
        catch (IOException e) {
            throw new KrbException("Failed to delete the identity " + principalName);
        }
    }

    protected void doStop() throws KrbException {
        try {
            this.rm.close();
        }
        catch (IOException e) {
            throw new KrbException("Failed to close the database", (Throwable)e);
        }
    }
}

