/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Map;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;
import org.apache.directory.mavibot.btree.serializer.LongSerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.kerby.KrbIdentityComparator;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;

public class KrbIdentitySerializer
implements ElementSerializer<KrbIdentity> {
    public static final KrbIdentitySerializer INSTANCE = new KrbIdentitySerializer();
    private KrbIdentityComparator comparator = KrbIdentityComparator.INSTANCE;

    public byte[] serialize(KrbIdentity entry) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(StringSerializer.INSTANCE.serialize(entry.getPrincipalName()));
            out.write(IntSerializer.serialize((int)entry.getKeyVersion()));
            out.write(IntSerializer.serialize((int)entry.getKdcFlags()));
            int mask = 0;
            if (entry.isDisabled()) {
                mask = (byte)(mask | 2);
            }
            if (entry.isLocked()) {
                mask = (byte)(mask | 4);
            }
            out.write(mask);
            out.write(LongSerializer.serialize((long)entry.getCreatedTime().getTime()));
            out.write(LongSerializer.serialize((long)entry.getExpireTime().getTime()));
            Map keys = entry.getKeys();
            out.write(IntSerializer.serialize((int)keys.size()));
            for (EncryptionKey ek : keys.values()) {
                int type = ek.getKeyType().getValue();
                out.write(IntSerializer.serialize((int)type));
                byte[] data = ek.getKeyData();
                out.write(IntSerializer.serialize((int)data.length));
                out.write(data);
            }
            return out.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to serialize the identity " + entry);
        }
    }

    public KrbIdentity deserialize(BufferHandler bufferHandler) throws IOException {
        return this.fromBytes(bufferHandler.getBuffer());
    }

    public KrbIdentity deserialize(ByteBuffer buffer) throws IOException {
        KrbIdentity id = null;
        String principal = StringSerializer.INSTANCE.deserialize(buffer);
        id = new KrbIdentity(principal);
        int kvno = IntSerializer.INSTANCE.deserialize(buffer);
        id.setKeyVersion(kvno);
        int flags = IntSerializer.INSTANCE.deserialize(buffer);
        id.setKdcFlags(flags);
        byte mask = buffer.get();
        if ((mask & 2) != 0) {
            id.setDisabled(true);
        }
        if ((mask & 4) != 0) {
            id.setLocked(true);
        }
        long creationTime = LongSerializer.INSTANCE.deserialize(buffer);
        id.setCreatedTime(new KerberosTime(creationTime));
        long exprTime = LongSerializer.INSTANCE.deserialize(buffer);
        id.setExpireTime(new KerberosTime(exprTime));
        int numKeys = IntSerializer.INSTANCE.deserialize(buffer);
        for (int i = 0; i < numKeys; ++i) {
            int keyType = IntSerializer.INSTANCE.deserialize(buffer);
            int keyLen = IntSerializer.INSTANCE.deserialize(buffer);
            byte[] keyData = new byte[keyLen];
            buffer.get(keyData);
            EncryptionKey ek = new EncryptionKey(keyType, keyData);
            id.addKey(ek);
        }
        return id;
    }

    public KrbIdentity fromBytes(byte[] buffer) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        return this.deserialize(buf);
    }

    public KrbIdentity fromBytes(byte[] buffer, int pos) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(buffer, pos, buffer.length - pos);
        return this.deserialize(buf);
    }

    public int compare(KrbIdentity type1, KrbIdentity type2) {
        return this.comparator.compare(type1, type2);
    }

    public Comparator<KrbIdentity> getComparator() {
        return this.comparator;
    }

    public Class<?> getType() {
        return KrbIdentity.class;
    }
}

