/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.keytab;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.kerby.kerberos.kerb.KrbInputStream;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.NameType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KeytabInputStream
extends KrbInputStream {
    public KeytabInputStream(InputStream in) {
        super(in);
    }

    @Override
    public KerberosTime readTime() throws IOException {
        long value = this.readInt();
        KerberosTime time = new KerberosTime(value * 1000L);
        return time;
    }

    @Override
    public PrincipalName readPrincipal(int version) throws IOException {
        int numComponents = this.readShort();
        if (version == 1281) {
            --numComponents;
        }
        String realm = this.readCountedString();
        ArrayList<String> nameStrings = new ArrayList<String>();
        for (int i = 0; i < numComponents; ++i) {
            String component = this.readCountedString();
            nameStrings.add(component);
        }
        int type = this.readInt();
        NameType nameType = NameType.fromValue((Integer)type);
        PrincipalName principal = new PrincipalName(nameStrings, nameType);
        principal.setRealm(realm);
        return principal;
    }

    public EncryptionKey readKey() throws IOException {
        short eType = this.readShort();
        EncryptionType encryptionType = EncryptionType.fromValue((Integer)Integer.valueOf(eType));
        byte[] keyData = this.readCountedOctets();
        EncryptionKey key = new EncryptionKey(encryptionType, keyData);
        return key;
    }

    @Override
    public String readCountedString() throws IOException {
        byte[] countedOctets = this.readCountedOctets();
        return new String(countedOctets, "ASCII");
    }

    @Override
    public int readOctetsCount() throws IOException {
        return this.readShort();
    }
}

