/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.identity.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;

public final class BackendTestUtil {
    static final String TEST_PRINCIPAL_PREFIX = "test";
    static final String TEST_REALM = "EXAMPLE.COM";
    public static final String TEST_PRINCIPAL = "test@EXAMPLE.COM";
    static final EncryptionType[] ENC_TYPES = new EncryptionType[]{EncryptionType.AES128_CTS, EncryptionType.DES3_CBC_SHA1_KD};

    public static void createManyIdentities(IdentityBackend backend, int count) throws KrbException {
        int howMany = count > 0 ? count : 20;
        List<KrbIdentity> identities = BackendTestUtil.createManyIdentities(howMany);
        for (KrbIdentity identity : identities) {
            backend.addIdentity(identity);
        }
    }

    public static KrbIdentity[] createManyIdentities() throws KrbException {
        List<KrbIdentity> results = BackendTestUtil.createManyIdentities(20);
        return results.toArray(new KrbIdentity[results.size()]);
    }

    public static List<KrbIdentity> createManyIdentities(int count) throws KrbException {
        ArrayList<KrbIdentity> results = new ArrayList<KrbIdentity>(count);
        for (int i = 0; i < count; ++i) {
            String tmp = TEST_PRINCIPAL_PREFIX + i + "@" + TEST_REALM;
            results.add(BackendTestUtil.createOneIdentity(tmp));
        }
        return results;
    }

    public static void createTheTestIdentity(IdentityBackend backend) throws KrbException {
        backend.addIdentity(BackendTestUtil.createOneIdentity(TEST_PRINCIPAL));
    }

    public static void getTheTestIdentity(IdentityBackend backend) throws KrbException {
        KrbIdentity identity = backend.getIdentity(TEST_PRINCIPAL);
        if (identity == null) {
            throw new KrbException("Failed to get the test principal");
        }
    }

    public static KrbIdentity createOneIdentity() throws KrbException {
        return BackendTestUtil.createOneIdentity(TEST_PRINCIPAL);
    }

    public static KrbIdentity createOneIdentity(String principal) throws KrbException {
        KrbIdentity kid = new KrbIdentity(principal);
        kid.setCreatedTime(KerberosTime.now());
        kid.setExpireTime(KerberosTime.now());
        kid.setDisabled(false);
        kid.setKeyVersion(1);
        kid.setLocked(false);
        kid.addKeys(BackendTestUtil.generateKeys());
        return kid;
    }

    public static List<EncryptionKey> generateKeys() throws KrbException {
        return EncryptionUtil.generateKeys(BackendTestUtil.getEncryptionTypes());
    }

    public static List<EncryptionType> getEncryptionTypes() {
        return Arrays.asList(ENC_TYPES);
    }
}

