/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.identity.backend;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendTestUtil;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public abstract class BackendTest {
    protected void testGet(IdentityBackend backend) throws KrbException {
        KrbIdentity kid = BackendTestUtil.createOneIdentity("test@EXAMPLE.COM");
        backend.addIdentity(kid);
        backend.release();
        KrbIdentity identity = backend.getIdentity("test@EXAMPLE.COM");
        Assertions.assertThat((Object)identity).isNotNull();
        Assertions.assertThat((Object)identity.getExpireTime()).isEqualTo((Object)kid.getExpireTime());
        Assertions.assertThat((boolean)identity.isDisabled()).isEqualTo(kid.isDisabled());
        Assertions.assertThat((int)identity.getKeyVersion()).isEqualTo(kid.getKeyVersion());
        for (EncryptionKey expectedKey : kid.getKeys().values()) {
            EncryptionType actualType = EncryptionType.fromValue((Integer)expectedKey.getKeyType().getValue());
            EncryptionKey actualKey = identity.getKey(actualType);
            Assertions.assertThat((int)actualKey.getKeyType().getValue()).isEqualTo(expectedKey.getKeyType().getValue());
            Assertions.assertThat((byte[])actualKey.getKeyData()).isEqualTo((Object)expectedKey.getKeyData());
            Assertions.assertThat((int)actualKey.getKvno()).isEqualTo(expectedKey.getKvno());
        }
        backend.deleteIdentity("test@EXAMPLE.COM");
    }

    protected void testStore(IdentityBackend backend) throws KrbException {
        KrbIdentity kid = BackendTestUtil.createOneIdentity("test@EXAMPLE.COM");
        backend.addIdentity(kid);
        backend.release();
        KrbIdentity kid2 = backend.getIdentity("test@EXAMPLE.COM");
        Assertions.assertThat((Object)kid).isEqualTo((Object)kid2);
        backend.deleteIdentity("test@EXAMPLE.COM");
    }

    protected void testUpdate(IdentityBackend backend) throws KrbException {
        KrbIdentity kid = BackendTestUtil.createOneIdentity("test@EXAMPLE.COM");
        backend.addIdentity(kid);
        kid.setDisabled(true);
        backend.updateIdentity(kid);
        backend.release();
        Assertions.assertThat((Object)backend.getIdentity("test@EXAMPLE.COM")).isEqualTo((Object)kid);
        backend.deleteIdentity("test@EXAMPLE.COM");
    }

    protected void testDelete(IdentityBackend backend) throws KrbException {
        KrbIdentity kid = BackendTestUtil.createOneIdentity("test@EXAMPLE.COM");
        backend.addIdentity(kid);
        backend.release();
        Assertions.assertThat((Object)backend.getIdentity("test@EXAMPLE.COM")).isNotNull();
        backend.deleteIdentity("test@EXAMPLE.COM");
        Assertions.assertThat((Object)backend.getIdentity("test@EXAMPLE.COM")).isNull();
    }

    protected void testGetIdentities(IdentityBackend backend) throws KrbException {
        KrbIdentity[] identities;
        for (KrbIdentity identity : identities = BackendTestUtil.createManyIdentities()) {
            backend.addIdentity(identity);
        }
        backend.release();
        Iterable principals = backend.getIdentities();
        Iterator iterator = principals.iterator();
        LinkedList<String> principalList = new LinkedList<String>();
        while (iterator.hasNext()) {
            principalList.add((String)iterator.next());
        }
        ((ListAssert)((ListAssert)((ListAssert)((ListAssert)((ListAssert)Assertions.assertThat(principalList).hasSize(identities.length)).contains((Object[])new String[]{identities[0].getPrincipalName()})).contains((Object[])new String[]{identities[1].getPrincipalName()})).contains((Object[])new String[]{identities[2].getPrincipalName()})).contains((Object[])new String[]{identities[3].getPrincipalName()})).contains((Object[])new String[]{identities[4].getPrincipalName()});
        for (KrbIdentity identity : identities) {
            backend.deleteIdentity(identity.getPrincipalName());
        }
    }

    protected void cleanIdentities(IdentityBackend backend) throws KrbException {
        Iterable identities = backend.getIdentities();
        Iterator iterator = identities.iterator();
        while (iterator.hasNext()) {
            backend.deleteIdentity((String)iterator.next());
        }
    }
}

