/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.transport;

import java.io.IOException;
import java.net.Socket;
import org.apache.kerby.kerberos.kerb.transport.AbstractKrbTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTcpTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbUdpTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;

public class KrbNetwork {
    private int socketTimeout = 10000;
    private TransportPair tpair;

    public KrbTransport connect(TransportPair tpair) throws IOException {
        this.tpair = tpair;
        AbstractKrbTransport transport = null;
        if (tpair.tcpAddress != null) {
            try {
                transport = this.tcpConnect();
            }
            catch (IOException e) {
                if (tpair.udpAddress != null) {
                    transport = new KrbUdpTransport(tpair.udpAddress);
                }
            }
        } else {
            transport = new KrbUdpTransport(tpair.udpAddress);
        }
        if (transport == null) {
            throw new IOException("Failed to establish the transport");
        }
        return transport;
    }

    private KrbTcpTransport tcpConnect() throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(this.socketTimeout);
        socket.connect(this.tpair.tcpAddress);
        return new KrbTcpTransport(socket);
    }

    public void setSocketTimeout(int milliSeconds) {
        this.socketTimeout = milliSeconds;
    }
}

