/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.client.request;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.type.Asn1Type;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.client.KrbContext;
import org.apache.kerby.kerberos.kerb.client.KrbKdcOption;
import org.apache.kerby.kerberos.kerb.client.KrbOptionGroup;
import org.apache.kerby.kerberos.kerb.client.preauth.KrbFastRequestState;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthContext;
import org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandler;
import org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.type.KerberosTime;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.HostAddress;
import org.apache.kerby.kerberos.kerb.type.base.HostAddresses;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOption;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcOptions;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcReqBody;
import org.apache.kerby.kerberos.kerb.type.pa.PaDataType;

public abstract class KdcRequest {
    protected Map<String, Object> credCache;
    private KrbContext context;
    private Object sessionData;
    private KOptions requestOptions;
    private PrincipalName serverPrincipal;
    private List<HostAddress> hostAddresses = new ArrayList<HostAddress>();
    private KdcOptions kdcOptions = new KdcOptions();
    private List<EncryptionType> encryptionTypes;
    private EncryptionType chosenEncryptionType;
    private int chosenNonce;
    private KdcReq kdcReq;
    private KdcReqBody reqBody;
    private KdcRep kdcRep;
    private PreauthContext preauthContext;
    private KrbFastRequestState fastRequestState;
    private EncryptionKey asKey;
    private byte[] outerRequestBody;
    private boolean isRetrying;

    public KdcRequest(KrbContext context) {
        this.context = context;
        this.isRetrying = false;
        this.credCache = new HashMap<String, Object>();
        this.preauthContext = context.getPreauthHandler().preparePreauthContext(this);
        this.fastRequestState = new KrbFastRequestState();
    }

    public KrbFastRequestState getFastRequestState() {
        return this.fastRequestState;
    }

    public void setFastRequestState(KrbFastRequestState state) {
        this.fastRequestState = state;
    }

    public byte[] getOuterRequestBody() {
        return (byte[])this.outerRequestBody.clone();
    }

    public void setOuterRequestBody(byte[] outerRequestBody) {
        this.outerRequestBody = (byte[])outerRequestBody.clone();
    }

    public Object getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Object sessionData) {
        this.sessionData = sessionData;
    }

    public KOptions getRequestOptions() {
        return this.requestOptions;
    }

    public void setRequestOptions(KOptions options) {
        this.requestOptions = options;
    }

    public boolean isRetrying() {
        return this.isRetrying;
    }

    public EncryptionKey getAsKey() throws KrbException {
        return this.asKey;
    }

    public void setAsKey(EncryptionKey asKey) {
        this.asKey = asKey;
    }

    public void setAllowedPreauth(PaDataType paType) {
        this.preauthContext.setAllowedPaType(paType);
    }

    public Map<String, Object> getCredCache() {
        return this.credCache;
    }

    public void setPreauthRequired(boolean preauthRequired) {
        this.preauthContext.setPreauthRequired(preauthRequired);
    }

    public void resetPrequthContxt() {
        this.preauthContext.reset();
    }

    public PreauthContext getPreauthContext() {
        return this.preauthContext;
    }

    public KdcReq getKdcReq() {
        return this.kdcReq;
    }

    public void setKdcReq(KdcReq kdcReq) {
        this.kdcReq = kdcReq;
    }

    protected KdcReqBody getReqBody() throws KrbException {
        if (this.reqBody == null) {
            this.reqBody = this.makeReqBody();
        }
        return this.reqBody;
    }

    public KdcRep getKdcRep() {
        return this.kdcRep;
    }

    public void setKdcRep(KdcRep kdcRep) {
        this.kdcRep = kdcRep;
    }

    protected KdcReqBody makeReqBody() throws KrbException {
        KdcReqBody body = new KdcReqBody();
        long startTime = System.currentTimeMillis();
        body.setFrom(new KerberosTime(startTime));
        PrincipalName cName = this.getClientPrincipal();
        body.setCname(cName);
        body.setRealm(this.getContext().getKrbSetting().getKdcRealm());
        PrincipalName sName = this.getServerPrincipal();
        body.setSname(sName);
        body.setTill(new KerberosTime(startTime + this.getTicketValidTime()));
        int nonce = this.generateNonce();
        body.setNonce(nonce);
        this.setChosenNonce(nonce);
        body.setKdcOptions(this.getKdcOptions());
        HostAddresses addresses = this.getHostAddresses();
        if (addresses != null) {
            body.setAddresses(addresses);
        }
        body.setEtypes(this.getEncryptionTypes());
        return body;
    }

    public KdcOptions getKdcOptions() {
        return this.kdcOptions;
    }

    public void setKdcOptions(KdcOptions kdcOptions) {
        this.kdcOptions = kdcOptions;
    }

    public HostAddresses getHostAddresses() {
        HostAddresses addresses = null;
        if (!this.hostAddresses.isEmpty()) {
            addresses = new HostAddresses();
            for (HostAddress ha : this.hostAddresses) {
                addresses.addElement((Asn1Type)ha);
            }
        }
        return addresses;
    }

    public void setHostAddresses(List<HostAddress> hostAddresses) {
        this.hostAddresses = hostAddresses;
    }

    public KrbContext getContext() {
        return this.context;
    }

    public void setContext(KrbContext context) {
        this.context = context;
    }

    protected byte[] decryptWithClientKey(EncryptedData data, KeyUsage usage) throws KrbException {
        EncryptionKey tmpKey = this.getClientKey();
        if (tmpKey == null) {
            throw new KrbException("Client key isn't availalbe");
        }
        return EncryptionHandler.decrypt((EncryptedData)data, (EncryptionKey)tmpKey, (KeyUsage)usage);
    }

    public abstract PrincipalName getClientPrincipal();

    public PrincipalName getServerPrincipal() {
        return this.serverPrincipal;
    }

    public void setServerPrincipal(PrincipalName serverPrincipal) {
        this.serverPrincipal = serverPrincipal;
    }

    public List<EncryptionType> getEncryptionTypes() {
        if (this.encryptionTypes == null) {
            this.encryptionTypes = this.context.getConfig().getEncryptionTypes();
        }
        return EncryptionUtil.orderEtypesByStrength(this.encryptionTypes);
    }

    public void setEncryptionTypes(List<EncryptionType> encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public EncryptionType getChosenEncryptionType() {
        return this.chosenEncryptionType;
    }

    public void setChosenEncryptionType(EncryptionType chosenEncryptionType) {
        this.chosenEncryptionType = chosenEncryptionType;
    }

    public int generateNonce() {
        return this.context.generateNonce();
    }

    public int getChosenNonce() {
        return this.chosenNonce;
    }

    public void setChosenNonce(int nonce) {
        this.chosenNonce = nonce;
    }

    public abstract EncryptionKey getClientKey() throws KrbException;

    public long getTicketValidTime() {
        return this.context.getTicketValidTime();
    }

    public KerberosTime getTicketTillTime() {
        long now = System.currentTimeMillis();
        return new KerberosTime(now + -694967296L);
    }

    public void addHost(String hostNameOrIpAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostNameOrIpAddress);
        this.hostAddresses.add(new HostAddress(address));
    }

    public void process() throws KrbException {
        this.processKdcOptions();
        this.preauth();
    }

    public abstract void processResponse(KdcRep var1) throws KrbException;

    public KOptions getPreauthOptions() {
        return new KOptions();
    }

    protected void preauth() throws KrbException {
        List<EncryptionType> etypes = this.getEncryptionTypes();
        if (etypes.isEmpty()) {
            throw new KrbException("No encryption type is configured and available");
        }
        EncryptionType encryptionType = etypes.iterator().next();
        this.setChosenEncryptionType(encryptionType);
        this.getPreauthHandler().preauth(this);
    }

    protected PreauthHandler getPreauthHandler() {
        return this.getContext().getPreauthHandler();
    }

    public void needAsKey() throws KrbException {
        EncryptionKey clientKey = this.getClientKey();
        if (clientKey == null) {
            throw new RuntimeException("Client key should be prepared or prompted at this time!");
        }
        this.setAsKey(clientKey);
    }

    public EncryptionType getEncType() {
        return this.getChosenEncryptionType();
    }

    public void askQuestion(String question, String challenge) {
        this.preauthContext.getUserResponser().askQuestion(question, challenge);
    }

    public EncryptionKey getArmorKey() {
        return this.fastRequestState.getArmorKey();
    }

    public KerberosTime getPreauthTime() {
        return KerberosTime.now();
    }

    public Object getCacheValue(String key) {
        return this.credCache.get(key);
    }

    public void cacheValue(String key, Object value) {
        this.credCache.put(key, value);
    }

    protected void processKdcOptions() {
        this.kdcOptions.setFlag((EnumType)KdcOption.FORWARDABLE);
        this.kdcOptions.setFlag((EnumType)KdcOption.PROXIABLE);
        this.kdcOptions.setFlag((EnumType)KdcOption.RENEWABLE_OK);
        for (KOption kOpt : this.requestOptions.getOptions()) {
            if (kOpt.getOptionInfo().getGroup() != KrbOptionGroup.KDC_FLAGS) continue;
            KrbKdcOption krbKdcOption = (KrbKdcOption)kOpt;
            KdcOption kdcOption = KdcOption.valueOf((String)krbKdcOption.name());
            boolean flagValue = this.requestOptions.getBooleanOption(kOpt, Boolean.valueOf(true));
            this.kdcOptions.setFlag((EnumType)kdcOption, flagValue);
        }
    }
}

