/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfig;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerOption;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.server.ServerSetting;

public class AdminServerSetting
implements ServerSetting {
    private final KOptions startupOptions;
    private final AdminServerConfig adminServerConfig;
    private final KdcConfig kdcConfig;
    private final BackendConfig backendConfig;

    public AdminServerSetting(KOptions startupOptions, AdminServerConfig adminServerConfig, KdcConfig kdcConfig, BackendConfig backendConfig) {
        this.startupOptions = startupOptions;
        this.adminServerConfig = adminServerConfig;
        this.kdcConfig = kdcConfig;
        this.backendConfig = backendConfig;
    }

    public AdminServerSetting(AdminServerConfig adminServerConfig, BackendConfig backendConfig, KdcConfig kdcConfig) {
        this(new KOptions(), adminServerConfig, kdcConfig, backendConfig);
    }

    public AdminServerConfig getAdminServerConfig() {
        return this.adminServerConfig;
    }

    public String getKdcRealm() {
        return this.kdcConfig.getKdcRealm();
    }

    public KdcConfig getKdcConfig() {
        return this.kdcConfig;
    }

    public BackendConfig getBackendConfig() {
        return this.backendConfig;
    }

    public String getAdminHost() {
        String adminHost = this.startupOptions.getStringOption((KOption)AdminServerOption.ADMIN_HOST);
        if (adminHost == null) {
            adminHost = this.adminServerConfig.getAdminHost();
        }
        return adminHost;
    }

    public int checkGetAdminTcpPort() throws KrbException {
        if (this.allowTcp()) {
            int adminPort = this.getAdminTcpPort();
            if (adminPort < 1) {
                throw new KrbException("Admin Server tcp port isn't set or configured");
            }
            return adminPort;
        }
        return -1;
    }

    public int checkGetAdminUdpPort() throws KrbException {
        if (this.allowUdp()) {
            int adminPort = this.getAdminUdpPort();
            if (adminPort < 1) {
                throw new KrbException("Admin Server udp port isn't set or configured");
            }
            return adminPort;
        }
        return -1;
    }

    public int getAdminTcpPort() {
        int tcpPort = this.startupOptions.getIntegerOption((KOption)AdminServerOption.ADMIN_TCP_PORT);
        if (tcpPort < 1) {
            tcpPort = this.adminServerConfig.getAdminTcpPort();
        }
        if (tcpPort < 1) {
            tcpPort = this.getAdminPort();
        }
        return tcpPort;
    }

    public int getAdminPort() {
        int adminPort = this.startupOptions.getIntegerOption((KOption)AdminServerOption.ADMIN_PORT);
        if (adminPort < 1) {
            adminPort = this.adminServerConfig.getAdminPort();
        }
        return adminPort;
    }

    public boolean allowTcp() {
        return this.startupOptions.getBooleanOption((KOption)AdminServerOption.ALLOW_TCP, this.adminServerConfig.allowTcp());
    }

    public boolean allowUdp() {
        return this.startupOptions.getBooleanOption((KOption)AdminServerOption.ALLOW_UDP, this.adminServerConfig.allowUdp());
    }

    public int getAdminUdpPort() {
        int udpPort = this.startupOptions.getIntegerOption((KOption)AdminServerOption.ADMIN_UDP_PORT);
        if (udpPort < 1) {
            udpPort = this.adminServerConfig.getAdminUdpPort();
        }
        if (udpPort < 1) {
            udpPort = this.getAdminPort();
        }
        return udpPort;
    }

    public String getAdminRealm() {
        String adminRealm = this.startupOptions.getStringOption((KOption)AdminServerOption.ADMIN_REALM);
        if (adminRealm == null || adminRealm.isEmpty()) {
            adminRealm = this.adminServerConfig.getAdminRealm();
        }
        return adminRealm;
    }
}

