/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin;

import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfigKey;
import org.apache.kerby.kerberos.kerb.common.Krb5Conf;

public class AdminServerConfig
extends Krb5Conf {
    private static final String KDCDEFAULT = "kdcdefaults";

    public boolean enableDebug() {
        return this.getBoolean(AdminServerConfigKey.KRB_DEBUG, true, new String[]{KDCDEFAULT});
    }

    public String getAdminServiceName() {
        return this.getString(AdminServerConfigKey.ADMIN_SERVICE_NAME, true, new String[]{KDCDEFAULT});
    }

    public String getAdminHost() {
        return this.getString(AdminServerConfigKey.ADMIN_HOST, true, new String[]{KDCDEFAULT});
    }

    public int getAdminPort() {
        Integer kdcPort = this.getInt(AdminServerConfigKey.ADMIN_PORT, true, new String[]{KDCDEFAULT});
        if (kdcPort != null && kdcPort > 0) {
            return kdcPort;
        }
        return -1;
    }

    public int getAdminTcpPort() {
        Integer kdcTcpPort = this.getInt(AdminServerConfigKey.ADMIN_TCP_PORT, true, new String[]{KDCDEFAULT});
        if (kdcTcpPort != null && kdcTcpPort > 0) {
            return kdcTcpPort;
        }
        return this.getAdminPort();
    }

    public Boolean allowTcp() {
        return this.getBoolean(AdminServerConfigKey.ADMIN_ALLOW_TCP, true, new String[]{KDCDEFAULT}) != false || this.getInt(AdminServerConfigKey.ADMIN_TCP_PORT, true, new String[]{KDCDEFAULT}) != null || this.getInt(AdminServerConfigKey.ADMIN_PORT, false, new String[]{KDCDEFAULT}) != null;
    }

    public Boolean allowUdp() {
        return this.getBoolean(AdminServerConfigKey.ADMIN_ALLOW_UDP, true, new String[]{KDCDEFAULT}) != false || this.getInt(AdminServerConfigKey.ADMIN_UDP_PORT, true, new String[]{KDCDEFAULT}) != null || this.getInt(AdminServerConfigKey.ADMIN_PORT, false, new String[]{KDCDEFAULT}) != null;
    }

    public int getAdminUdpPort() {
        Integer kdcUdpPort = this.getInt(AdminServerConfigKey.ADMIN_UDP_PORT, true, new String[]{KDCDEFAULT});
        if (kdcUdpPort != null && kdcUdpPort > 0) {
            return kdcUdpPort;
        }
        return this.getAdminPort();
    }

    public String getAdminRealm() {
        return this.getString(AdminServerConfigKey.ADMIN_REALM, true, new String[]{KDCDEFAULT});
    }

    public String getAdminDomain() {
        return this.getString(AdminServerConfigKey.ADMIN_DOMAIN, true, new String[]{KDCDEFAULT});
    }

    public String getKeyTabFile() {
        return this.getString(AdminServerConfigKey.KEYTAB_FILE, true, new String[]{KDCDEFAULT});
    }

    public String getProtocol() {
        return this.getString(AdminServerConfigKey.PROTOCOL, true, new String[]{KDCDEFAULT});
    }

    public String getServerName() {
        return this.getString(AdminServerConfigKey.SERVER_NAME, true, new String[]{KDCDEFAULT});
    }
}

