/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server;

import java.io.File;
import java.io.IOException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.Krb5Conf;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServer;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfig;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.server.KdcUtil;
import org.apache.kerby.util.OSUtil;

public class KerbyAdminServer {
    private static final String USAGE = (OSUtil.isWindows() ? "Usage: bin\\admin-server.cmd" : "Usage: sh bin/admin-server.sh") + " <conf-file>\n\tExample:\n\t\t" + (OSUtil.isWindows() ? "bin\\admin-server.cmd" : "sh bin/admin-server.sh") + " conf\n";

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println(USAGE);
            System.exit(1);
        }
        String confDirPath = args[0];
        AdminServer adminServer = new AdminServer(new File(confDirPath));
        AdminServerConfig adminServerConfig = adminServer.getAdminServerConfig();
        adminServer.setAdminHost(adminServerConfig.getAdminHost());
        adminServer.setAllowTcp(true);
        adminServer.setAllowUdp(false);
        adminServer.setAdminServerPort(adminServerConfig.getAdminPort());
        KdcConfig kdcConfig = KdcUtil.getKdcConfig((File)new File(confDirPath));
        if (kdcConfig == null) {
            kdcConfig = new KdcConfig();
        }
        try {
            Krb5Conf krb5Conf = new Krb5Conf(new File(confDirPath), kdcConfig);
            krb5Conf.initKrb5conf();
        }
        catch (IOException e) {
            throw new KrbException("Failed to make krb5.conf", (Throwable)e);
        }
        try {
            adminServer.init();
        }
        catch (KrbException e) {
            System.err.println("Errors occurred when start admin server:  " + e.getMessage());
            System.exit(2);
        }
        adminServer.start();
        System.out.println("Admin server started!");
    }
}

