/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.io.File;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class KeytabAddCommand
extends KadminCommand {
    private static final String USAGE = "Usage: ktadd [-k[eytab] keytab] [-q] [-e keysaltlist] [-norandkey] [principal | -glob princ-exp] [...]";
    private static final String DEFAULT_KEYTAB_FILE_LOCATION = "/etc/krb5.keytab";

    public KeytabAddCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split(" ");
        String principal = null;
        String keytabFileLocation = null;
        boolean glob = false;
        for (int index = 1; index < commands.length; ++index) {
            String command = commands[index];
            if (command.equals("-k")) {
                if (++index >= commands.length) {
                    System.err.println(USAGE);
                    return;
                }
                keytabFileLocation = commands[index].trim();
                continue;
            }
            if (command.equals("-glob")) {
                glob = true;
                continue;
            }
            if (command.startsWith("-")) continue;
            principal = command;
        }
        if (keytabFileLocation == null) {
            keytabFileLocation = DEFAULT_KEYTAB_FILE_LOCATION;
        }
        File keytabFile = new File(keytabFileLocation);
        if (principal == null) {
            System.out.println((glob ? "princ-exp" : "principal") + " not specified!");
            System.err.println(USAGE);
            return;
        }
        try {
            if (glob) {
                List principals = this.getKadmin().getPrincipals(principal);
                if (principals.size() != 0) {
                    this.getKadmin().exportKeytab(keytabFile, principals);
                }
            } else {
                this.getKadmin().exportKeytab(keytabFile, principal);
            }
            System.out.println("Export Keytab to " + keytabFileLocation);
        }
        catch (KrbException e) {
            System.err.println("Principal \"" + principal + "\" fail to add entry to keytab." + e.getMessage());
        }
    }
}

