/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class ChangePasswordCommand
extends KadminCommand {
    private static final String USAGE = "Usage: change_password [-randkey] [-keepold] [-e keysaltlist] [-pw password] principal";
    private KOptions kOptions;

    public ChangePasswordCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split("\\s");
        String principal = commands[commands.length - 1];
        if (commands.length <= 1) {
            System.err.println(USAGE);
            return;
        }
        if (commands.length == 2) {
            String password = this.getPassword(principal);
            if (password == null) {
                System.out.println("Did not get new password successfully. Please try again");
                return;
            }
            try {
                this.getKadmin().changePassword(principal, password);
                System.out.println("Update password success.");
            }
            catch (KrbException e) {
                System.err.println("Fail to update password. " + e.getCause());
            }
        } else {
            this.kOptions = ToolUtil.parseOptions(commands, 1, commands.length - 2);
            if (this.kOptions == null) {
                System.err.println(USAGE);
                return;
            }
            if (this.kOptions.contains((KOption)KadminOption.PW)) {
                String password = this.kOptions.getStringOption((KOption)KadminOption.PW);
                try {
                    this.getKadmin().changePassword(principal, password);
                    System.out.println("Update password success.");
                }
                catch (KrbException e) {
                    System.err.println("Fail to update password. " + e.getMessage());
                }
            } else if (this.kOptions.contains((KOption)KadminOption.RANDKEY)) {
                try {
                    this.getKadmin().updateKeys(principal);
                }
                catch (KrbException e) {
                    System.err.println("Fail to update key. " + e.getMessage());
                }
            }
        }
    }

    private String getPassword(String principal) {
        String passwordTwice;
        String passwordOnce;
        Console console = System.console();
        if (console == null) {
            System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
            Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
            passwordOnce = this.getPassword(scanner, "Please enter new password  \"" + principal + "\":");
            passwordTwice = this.getPassword(scanner, "Please re-enter password  =\"" + principal + "\":");
        } else {
            passwordOnce = this.getPassword(console, "Please enter new password \"" + principal + "\":");
            passwordTwice = this.getPassword(console, "Please re-enter password \"" + principal + "\":");
        }
        if (!passwordOnce.equals(passwordTwice)) {
            System.err.println("change_password: Password mismatch while reading password for \"" + principal + "\".");
            return null;
        }
        return passwordOnce;
    }

    private String getPassword(Scanner scanner, String prompt) {
        System.out.println(prompt);
        return scanner.nextLine().trim();
    }

    private String getPassword(Console console, String prompt) {
        console.printf(prompt, new Object[0]);
        char[] passwordChars = console.readPassword();
        String password = new String(passwordChars).trim();
        Arrays.fill(passwordChars, ' ');
        return password;
    }
}

